/* ***************************************************************************************
* FILE:          CGIAppViewController_Navigation.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewController_Navigation.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) -2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined (_CGIAPPVIEWCONTROLLER_NAVIGATION_H)
#define _CGIAPPVIEWCONTROLLER_NAVIGATION_H

#include "CgiExtensions/ViewControllerBase.h"

#define SIMPLE_CONTROLLER(tController)\
		class tController : public ViewControllerBase\
		{\
		private:\
			courier_messages:\
		      COURIER_MSG_MAP_BEGIN(0)\
                COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()\
                COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()\
            COURIER_MSG_MAP_ENDS()\
		public:\
		   tController() {}\
		   virtual ~tController() {}\
		   static const char* _name;\
		   static Courier::ViewController* createInstance()\
		   {\
			  return COURIER_NEW(tController)();\
		   }\
		};

/* Scenes */
SIMPLE_CONTROLLER(CGIAppViewController_Address_DetailedInfo)
SIMPLE_CONTROLLER(CGIAppViewController_Disclaimer)
SIMPLE_CONTROLLER(CGIAppViewController_Favourites)
SIMPLE_CONTROLLER(CGIAppViewController_Fav_AddFavorites)
SIMPLE_CONTROLLER(CGIAppViewController_Fav_SetHome)
SIMPLE_CONTROLLER(CGIAppViewController_Guidance)
SIMPLE_CONTROLLER(CGIAppViewController_Guidance_BlockRouteList)
SIMPLE_CONTROLLER(CGIAppViewController_Guidance_ShowRouteList)
SIMPLE_CONTROLLER(CGIAppViewController_LastDestinations)
SIMPLE_CONTROLLER(CGIAppViewController_LatLongInput)
SIMPLE_CONTROLLER(CGIAppViewController_Map)
SIMPLE_CONTROLLER(CGIAppViewController_Map_ActiveRG)
SIMPLE_CONTROLLER(CGIAppViewController_Map_Move)
SIMPLE_CONTROLLER(CGIAppViewController_MyPOIs_AddressInput)
SIMPLE_CONTROLLER(CGIAppViewController_NewDestination)
SIMPLE_CONTROLLER(CGIAppViewController_OPT)
SIMPLE_CONTROLLER(CGIAppViewController_OPT_GuidanceOptions)
SIMPLE_CONTROLLER(CGIAppViewController_OPT_MapOptions)
SIMPLE_CONTROLLER(CGIAppViewController_OPT_MapOptions_OnMap)
SIMPLE_CONTROLLER(CGIAppViewController_OPT_MapOption_MapColor)
SIMPLE_CONTROLLER(CGIAppViewController_OPT_MapOption_Others)
SIMPLE_CONTROLLER(CGIAppViewController_OPT_PositionAndGPSInfo)
SIMPLE_CONTROLLER(CGIAppViewController_OPT_RouteOptions)
SIMPLE_CONTROLLER(CGIAppViewController_OPT_RouteOptions_Others)
SIMPLE_CONTROLLER(CGIAppViewController_OPT_TrafficIcons)
SIMPLE_CONTROLLER(CGIAppViewController_OPT_VehicleOptions)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MultiLine_TwoButton)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_ThreeLine_TwoButton)
SIMPLE_CONTROLLER(CGIAppViewController_POIDetailedInfo)
SIMPLE_CONTROLLER(CGIAppViewController_POIInfo)
SIMPLE_CONTROLLER(CGIAppViewController_POI_CategoryRoot)
SIMPLE_CONTROLLER(CGIAppViewController_POI_CategorySublevel)
SIMPLE_CONTROLLER(CGIAppViewController_POI_DetailedInfo)
SIMPLE_CONTROLLER(CGIAppViewController_POI_List)
SIMPLE_CONTROLLER(CGIAppViewController_POI_ListEmpty)
SIMPLE_CONTROLLER(CGIAppViewController_ReplaceFavorites)
SIMPLE_CONTROLLER(CGIAppViewController_SpellerEdit)
SIMPLE_CONTROLLER(CGIAppViewController_SpellerEdit_FreeText)
SIMPLE_CONTROLLER(CGIAppViewController_Speller_MatchList)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_Dest_CalcRoute)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_Dest_VehicleInfo)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_HomeEdit_Info_ThreeLine)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_LatLong_Invalid)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MultiLine_Text)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_SingleLine_TwoButton)
SIMPLE_CONTROLLER(CGIAppViewController_Speller_EU_ABC_Symbol)
SIMPLE_CONTROLLER(CGIAppViewController_Speller_EU_SpecialCharacters)
SIMPLE_CONTROLLER(CGIAppViewController_Speller_LatLong_DialPad)
SIMPLE_CONTROLLER(CGIAppViewController_Navigation_Gadget)
SIMPLE_CONTROLLER(CGIAppViewController_StreamedMap_Settings)
SIMPLE_CONTROLLER(CGIAppViewController_StreamedMap_SettingsSubOptions)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MapUpdate_Error)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MapUpdate_Interactive)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MapUpdate_Progress)
SIMPLE_CONTROLLER(CGIAppViewController_OPT_SpeedLimitOption)
SIMPLE_CONTROLLER(CGIAppViewController_OPT_PremiumTraffic)
SIMPLE_CONTROLLER(CGIAppViewController_OPT_TrafficOptions)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MultiLine_text_1)
SIMPLE_CONTROLLER(CGIAppViewController_OPT_PremiumTraffic_Disclaimer)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MapOut_Notification)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_RouteInfo)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_LCVRestrictionInfo)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_FourLine_SingleButton)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_SpeedLockInfo)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_FiveLine_TwoButton)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_ThreeLine_Text)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_SingleLine_SingleButton)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_XUrgent_Message)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_Sys_ThreeLine_Text)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_ThreeLine_OneButton)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_SoftPhysicalRestrictionInfo)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_AvoidTollRoad)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_PremiumTrafficDisabled)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_LCVHardRestrictionInfo_Multiple)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_LCVHardRestrictionConfirm_Multiple)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_LCVHardRestrictionInfo_ActiveRG)
#endif // _CGIAPPVIEWCONTROLLER_Navigation_H
