/* ***************************************************************************************
* FILE:          CGIAppPopupTable.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppPopupTable.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) -2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "CgiExtensions/PopupConfig.h"

// the views
#include "CGIAppViewController_Navigation.h"
#include "ProjectBaseTypes.h"

POPUP_TABLE_BEGIN() // popup ID, modality, priority, presentation time, min. presentation time, validity period, close on superseded, close on app leave, surface ID, path in asset
POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_LatLong_Invalid),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_SingleLine_TwoButton),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 4000, 2000, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_MultiLine_Text),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_MultiLine_TwoButton),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_ThreeLine_TwoButton),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 10, 0, 2000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_Dest_CalcRoute),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_Dest_VehicleInfo),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 4000, 3000, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_HomeEdit_Info_ThreeLine),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 3000, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_SpeedLockInfo),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_FiveLine_TwoButton),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 3000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_ThreeLine_Text),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_SingleLine_SingleButton),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_ThreeLine_OneButton),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_MapUpdate_Progress),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 10, 4000, 3000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_RouteInfo),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 10, 0, 3000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_LCVRestrictionInfo),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 4000, 3000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_MapOut_Notification),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 7, 0, 3000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_FourLine_SingleButton),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 7, 0, 3000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_XUrgent_Message),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 7, 4000, 3000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_Sys_ThreeLine_Text),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 13, 0, 3000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_MapUpdate_Error),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 13, 0, 3000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_MapUpdate_Interactive),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 10, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_SoftPhysicalRestrictionInfo),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_AvoidTollRoad),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_PremiumTrafficDisabled), //Story 934944 - Premium Traffic setting to be enabled/disabled based on the Bluetooth connectivity
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_LCVHardRestrictionInfo_Multiple),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_LCVHardRestrictionConfirm_Multiple),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION, CGIAppViewController_Pfo_LCVHardRestrictionInfo_ActiveRG),
                  POPUP_TABLE_ENTRY_DUMMY()
                  POPUP_TABLE_END()
