/**************************************************************************************
* @file         : EngineeringMenuHandler.h
* @author       : Atchuta Sashank Kappagantu
* @addtogroup   : AppHmi_Testmode
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef ENGINEERING_MENU_HANDLER_H
#define ENGINEERING_MENU_HANDLER_H

#include "AppHmi_NavigationStateMachine.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"

class EngineeringMenuHandler : public HMIModelBase, public ListImplementation
{
   public:
      EngineeringMenuHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~EngineeringMenuHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ENGINEERING_MENU_CHANGED, onPropertyUpdateEngineeringMenuInfoChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      void onPropertyUpdateEngineeringMenuInfoChanged();

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(ResetEngineeringMenuReqMsg)
      ON_COURIER_MESSAGE(DeselectEngineeringMenuReqMsg)
      ON_COURIER_MESSAGE(EnterEngineeringMenuReqMsg)
      ON_COURIER_MESSAGE(ExitEngineeringMenuReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS();

      // Incoming events
      bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      bool onCourierMessage(const ResetEngineeringMenuReqMsg& oMsg);
      bool onCourierMessage(const DeselectEngineeringMenuReqMsg& oMsg);
      bool onCourierMessage(const EnterEngineeringMenuReqMsg& oMsg);
      bool onCourierMessage(const ExitEngineeringMenuReqMsg& oMsg);

   private:
      tSharedPtrDataProvider getEngineeringMenuListDataProvider(unsigned int startIndex, unsigned int windowElementSize) const;
      void updateEngineeringMenuBinding();
      /** Function to update list data of a specified index */
      void updateListElemets();
      void updateMenuEntries();

      unsigned int _listId;
      unsigned int _startIndex;
      unsigned int _windowElementSize;
      bool isDemoModeItemPressed; //Set when Demomode item pressed
      bool isMenuTypeItemPressed; // Set when MenuType items pressed

      /** Binding source for the Test Mode GNSS detailed text */
      DataBindingItem<EngineeringMenuDetailsDataBindingSource> _engineeringMenuDetailedText;
      /** Binding source for the to distinguish between header text for engineering menu*/
      DataBindingItem<EngineeringMenuTitleDataBindingSource> _engineeringMenuTitle;
      /** Binding source data guards for engineering menu*/
      DataBindingItem<EngineeringMenuListCheckDataBindingSource> _engineeringMenuListCheck;

   protected:
      using ListImplementation::onCourierMessage;
};


#endif /* _ENGINEERING_MENU_HANDLER_H */
