/**************************************************************************************
* @file         : VehicleSettingsMetaData.h
* @author       : Preethi Alagappan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef VECHILE_SETTINGS_META_DATA_H
#define VECHILE_SETTINGS_META_DATA_H

enum VehicleSettingsListItemValue
{
   VEHICLE_SETTINGS_PROFILE,
   VEHICLE_SETTINGS_HEIGHT,
   VEHICLE_SETTINGS_LENGTH,
   VEHICLE_SETTINGS_WIDTH,
   VEHICLE_SETTINGS_TOTAL_WEIGHT,
   VEHICLE_SETTINGS_LOAD_PER_AXLE,
   VEHICLE_SETTINGS_MAX_SPEED,
   VEHICLE_SETTINGS_TRAILER_TYPE,
   VEHICLE_SETTINGS_GOODS_TYPE
};


enum HazardousSettingsListItemValue
{
   VEHICLE_SETTINGS_NO_LOAD,
   VEHICLE_SETTINGS_NO_HAZARDOUS,
   VEHICLE_SETTINGS_WATER_POLLUTING,
   VEHICLE_SETTINGS_EXPLOSIVES,
   VEHICLE_SETTINGS_GAS
};


enum CoachProfileType
{
   COACH_PROFILE_1 = 0,
   COACH_PROFILE_DEFAULT = 1
};


enum CurrentVehicleProfileType
{
   CURRENT_VEHICLETYPE_USER_1 = 0,
   CURRENT_VEHICLETYPE_USER_2 = 1,
   CURRENT_VEHICLETYPE_USER_3 = 2,
   CURRENT_VEHICLETYPE_DEFAULT = 3
};


enum VehicleRestrictionsPriorityType
{
   VEHICLE_RESTRICTIONS_WEIGHT,
   VEHICLE_RESTRICTIONS_WEIGHT_PER_AXLE,
   VEHICLE_RESTRICTIONS_WIDTH,
   VEHICLE_RESTRICTIONS_HEIGHT,
   VEHICLE_RESTRICTIONS_LENGTH,
   VEHICLE_RESTRICTIONS_GOODS_TYPE
};


struct VehicleSettingsMetaData
{
   float minValue;   // Minimum value of the setting
   float maxValue;   // Maximum value of the setting
   float step;       // Step by which the setting value should be incremented or decremented
};


const VehicleSettingsMetaData vehicleSettingsMetricMetaData[MAX_SIZE_VEHICLE_SETTINGS] =
{
   { 0.0F, 0.0F, 0.0F }       // Profile of the vehicle
   , { 2.0F, 5.0F, 0.1F }     // Height of the vehicle in metre
   , { 8.0F, 30.0F, 0.5F }    // Length of the vehicle in metre
   , { 2.0F, 3.0F, 0.05F }    // Width of the vehicle in metre
   , { 10.0F, 50.0F, 0.5F }   // Weight of the vehicle in tonne
   , { 7.0F, 20.0F, 0.5F }    // Load per axle of the vehicle in tonne
   , { 80.0F, 130.0F, 5.0F }  // Maximum speed of the vehicle in kmph
   , { 0.0F, 3.0F, 1.0F }     // Trailer type of the vehicle
   , { 0.0F, 0.0F, 0.0F }     // Goods type of the vehicle
};


const VehicleSettingsMetaData vehicleSettingsImperialMetaData[MAX_SIZE_VEHICLE_SETTINGS] =
{
   { 0.0F, 0.0F, 0.0F }      // Profile of the vehicle
   , { 2.2F, 5.5F, 0.1F }    // Height of the vehicle in yard
   , { 8.8F, 32.8F, 0.5F }   // Length of the vehicle in yard
   , { 2.2F, 3.28F, 0.05F }  // Width of the vehicle in yard
   , { 10.0F, 50.0F, 0.5F }  // Weight of the vehicle in tonne
   , { 7.0F, 20.0F, 0.5F }   // Load per axle of the vehicle in tonne
   , { 50.0F, 80.0F, 5.0F }  // Maximum speed of the vehicle in mph
   , { 0.0F, 3.0F, 1.0F }    // Trailer type of the vehicle
   , { 0.0F, 0.0F, 0.0F }    // Goods type of the vehicle
};


#endif // VECHILE_SETTINGS_META_DATA_H
