/**************************************************************************************
* @file         : VehicleDimensionsConverter.h
* @author       : Preethi Alagappan
* @addtogroup   : AppHmi_Navigation
* @brief        : Helper class for converting vehicle dimensions to different units
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef VECHILE_DIMENSIONS_CONVERTER_H
#define VECHILE_DIMENSIONS_CONVERTER_H

class VehicleDimensionsConverter
{
   public:
      static float metersToMillimeters(float dimensionsInMeters);
      static float millimetersToMeters(float dimensionsInMillimeters);
      static float millimetersToInches(float dimensionsInMillimeters);
      static float centimetersToMeters(float dimensionsInCentimeters);
      static float millimetersToYards(float dimensionsInMillimeters);
      static float inchesToMillimeters(float dimensionsInInches);
      static float inchesToYards(float dimensionsInInches);
      static float yardsToInches(float dimensionsInYards);
      static float inchesToMeters(float dimensionsInInches);

      static float tonnesToKilograms(float dimensionsInTonnes);
      static float tonnesToPounds(float dimensionsInTonnes);
      static float kilogramsToTonnes(float dimensionsInKilograms);
      static float kilogramsToPounds(float dimensionsInKilograms);
      static float poundsToKilograms(float dimensionsInPounds);
      static float poundsToTonnes(float dimensionsInPounds);

      static float kmphToMph(float dimensionsInKmph);
      static float mphToKmph(float dimensionsInMph);
};


#endif	// VECHILE_DIMENSIONS_CONVERTER_H
