/**************************************************************************************
* @file         : UserPOISettingsListHandler.h
* @author       : ECG-Atchuta Sashank Kappagantu
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (C) 2020 Robert Bosch GmbH
*                 (C) 2020 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef USER_POI_SETTINGS_LIST_HANDLER_H
#define USER_POI_SETTINGS_LIST_HANDLER_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"

#ifdef HALL_TO_MDW_COM

class UserPOISettingsListHandler : public HMIModelBase, public ListImplementation
{
   public:
      UserPOISettingsListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~UserPOISettingsListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_UPOIS_DELETED , onPropertyUpdateUPoisDeleted)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_UPOIS_IMPORT_STATUS_CHANGED , onPropertyUpdateImportStatusChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      void onPropertyUpdateUPoisDeleted();
      void onPropertyUpdateImportStatusChanged();

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(UPOIDeviceStatusUpdMsg)
      ON_COURIER_MESSAGE(DeleteAllUPOIsReqMsg)
      ON_COURIER_MESSAGE(ImportUPOIsReqMsg)

      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()

      COURIER_MSG_MAP_ENDS()

      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      bool onCourierMessage(const UPOIDeviceStatusUpdMsg& oMsg);
      bool onCourierMessage(const DeleteAllUPOIsReqMsg& oMsg);
      bool onCourierMessage(const ImportUPOIsReqMsg& oMsg);

   private:
      enum MyPOIsListItemValue
      {
         USER_POI_ALERT,
         USER_POI_IMPORT_FROM_USB,
         USER_POI_DELETE
      };
      enum enImportStatus
      {
         IMPORT_STATUS__AWAITING_USER_RESPONSE,
         IMPORT_STATUS__INITIATED,
         IMPORT_STATUS__IN_PROGRESS,
         IMPORT_STATUS__INVALID
      };

      bool _deviceStatus;
      ::std::string _myPOIsPath;
      enImportStatus _hmiImportStatus;

      typedef ListItemBase<MyPOIsListItemValue> MyPOIsListItem;
      std::vector<MyPOIsListItem> _myPOIsList;
      DataBindingItem<TwoLinePopuptextDataBindingSource> _twoLinePopupText;
      DataBindingItem<MultiLinePopuptextDataBindingSource> _popupText;
      DataBindingItem<MultiLinePopupTextDataBindingSource> _multiLinePopupText;
      DataBindingItem<FiveLinePopupTextDataBindingSource> _fiveLinePopupText;
      DataBindingItem<MyPOIsAvailabilityDataBindingSource> _myPOIsAvailability;

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getListDataProviderMainList();
      void vUPOIPopUpChangeRequest(const Courier::UInt8& popupType);
      void setMyPOIsAvailability(bool isAvailable);
      void changeMyPOIsButtonState(bool isEnabled);
      FEATSTD_MAKE_CLASS_UNCOPYABLE(UserPOISettingsListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // USER_POI_SETTINGS_LIST_HANDLER_H
