/**************************************************************************************
* @file         : StreamedMapTypeSettingListHandler.h
* @author       :  ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef STREAMED_MAP_TYPE_SETTING_LIST_HANDLER_H
#define STREAMED_MAP_TYPE_SETTING_LIST_HANDLER_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"
#include "AppHmi_NavigationStateMachine.h"


#ifdef HALL_TO_MDW_COM

class StreamedMapTypeSettingListHandler : public NavMiddlewarePropertyUpdateConsumer
{
   public:
      StreamedMapTypeSettingListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~StreamedMapTypeSettingListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      bool handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg);
      void updateMapContent();

   private:
      Candera::UInt8 _currentMapContent;

      void updateAvailableMapList();

      enum SettingsStreamMapType
      {
         STREAMED_MAP_OPTION_OVERVIEW_MAP,
         STREAMED_MAP_OPTION_2D_MAP,
         STREAMED_MAP_OPTION_3D_MAP,
         STREAMED_MAP_OPTION_INVALID
      };

      typedef ListItemBase<SettingsStreamMapType> StreamMapTypeListItem;
      std::vector<StreamMapTypeListItem> _streamMapTypeItemList;
      std::vector<Candera::UInt8> _availableMapType;
      IsButtonToggleEnabled _stremMapTypeCheckboxValue[3];
      FEATSTD_MAKE_CLASS_UNCOPYABLE(StreamedMapTypeSettingListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // STREAMED_MAP_TYPE_SETTING_LIST_HANDLER_H
