/**************************************************************************************
* @file         : StreamedMapTypeSettingListHandler.cpp
* @author       : ECG-NAveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include  <vector>
#include "StreamedMapTypeSettingListHandler.h"
#include "MapSettingsOthersUtil.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/StreamedMapTypeSettingListHandler.cpp.trc.h"
#endif

#ifdef  HALL_TO_MDW_COM
const Candera::UInt8 MAX_LIST_SIZE = 3;

StreamedMapTypeSettingListHandler::StreamedMapTypeSettingListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore)
   : NavMiddlewarePropertyUpdateConsumer(navMiddleware)
   , _currentMapContent(STREAMED_MAP_OPTION_2D_MAP)
{
   // configuring static list item
   _stremMapTypeCheckboxValue[0] = BUTTON_TOGGLE_ENABLED_FALSE;
   for (int itr = 1; itr < MAX_LIST_SIZE; itr++)
   {
      _stremMapTypeCheckboxValue[itr] = BUTTON_TOGGLE_ENABLED_TRUE;
   }
}


StreamedMapTypeSettingListHandler::~StreamedMapTypeSettingListHandler()
{
}


void StreamedMapTypeSettingListHandler::initialize()
{
   _streamMapTypeItemList.reserve(MAX_LIST_SIZE);
   _streamMapTypeItemList.push_back(StreamMapTypeListItem(LANGUAGE_STRING(TextId_0x1428, "Route overview map"), IS_VISIBLE_FALSE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_OPTION_OVERVIEW_MAP));
   _streamMapTypeItemList.push_back(StreamMapTypeListItem(LANGUAGE_STRING(TextId_0x13E8, "2D map"), IS_VISIBLE_FALSE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_OPTION_2D_MAP));
   _streamMapTypeItemList.push_back(StreamMapTypeListItem(LANGUAGE_STRING(TextId_0x13EA, "3D map"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_OPTION_3D_MAP));
   updateAvailableMapList();
}


void StreamedMapTypeSettingListHandler::deinitialize()
{
}


tSharedPtrDataProvider StreamedMapTypeSettingListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("StreamedMapTypeSettingListHandler::getListDataProvider(List ID %d)", oMsg.GetListId()));

   DataItemContext  listItemName = "Layer_Checkbox";
   Candera::UInt32 listID = oMsg.GetListId();
   ListDataProviderBuilder listBuilder(listID);
   Candera::UInt8 checkboxIdx = 0;

   for (std::vector<StreamMapTypeListItem>::iterator itemNumber = _streamMapTypeItemList.begin(); ((itemNumber < _streamMapTypeItemList.end()) && (checkboxIdx < MAX_LIST_SIZE)); ++itemNumber, ++checkboxIdx)
   {
      if (itemNumber->_listButtonType == LIST_BUTTON_TYPE_TOGGLE)
      {
         //Enable Show RouteMap View only when route guidance is active
         //Will be uncommented when middleware supports route overview for Stream Map view
         //if ((checkboxIdx == STREAMED_MAP_OPTION_OVERVIEW_MAP))
         //{
         //   if (_navMiddleware.isGuidanceActive() == true)
         //   {
         //      itemNumber->_isVisible = IS_VISIBLE_TRUE;
         //   }
         //   else
         //   {
         //      itemNumber->_isVisible = IS_VISIBLE_FALSE;
         //   }
         //}

         listBuilder.AddItem(
            itemNumber->_order,
            0UL,  //    - unused
            listItemName)  //0 - Name(Id) of the button
         .AddData(itemNumber->_text)
         .AddData(_stremMapTypeCheckboxValue[checkboxIdx])
         .AddData(itemNumber->_isVisible);
      }
   }
   updateAvailableMapList();

   return listBuilder.CreateDataProvider();
}


bool StreamedMapTypeSettingListHandler::handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg)
{
   ETG_TRACE_USR4(("StreamedMapTypeSettingListHandler::handleButtonListItemUpdMsg(%d)", oMsg.GetHdl()));

   navmiddleware::settings::MapTextFilterSettings mapTextFilterSettings = _navMiddleware.getMapTextFilterSettings();
   bool listUpdateNeeded = true;
   Candera::UInt32 listId = oMsg.GetListId();
   unsigned int rowID = (unsigned int)oMsg.GetHdl();
   const enReaction  reaction = oMsg.GetReaction();

   if ((LIST_ID_STEAM_MAP_SUBOPTIONS == listId) && (enRelease == reaction))
   {
      switch (rowID)
      {
         case STREAMED_MAP_OPTION_OVERVIEW_MAP:
         {
            _stremMapTypeCheckboxValue[STREAMED_MAP_OPTION_OVERVIEW_MAP] = toggleCheckbox(_stremMapTypeCheckboxValue[STREAMED_MAP_OPTION_OVERVIEW_MAP]);
            break;
         }
         case STREAMED_MAP_OPTION_2D_MAP:
         {
            _stremMapTypeCheckboxValue[STREAMED_MAP_OPTION_2D_MAP] = toggleCheckbox(_stremMapTypeCheckboxValue[STREAMED_MAP_OPTION_2D_MAP]);
            break;
         }
         case STREAMED_MAP_OPTION_3D_MAP: // Road _Names
         {
            _stremMapTypeCheckboxValue[STREAMED_MAP_OPTION_3D_MAP] = toggleCheckbox(_stremMapTypeCheckboxValue[STREAMED_MAP_OPTION_3D_MAP]);
            break;
         }
         default:
         {
            listUpdateNeeded = false;
            break;
         }
      }
   }

   if (listUpdateNeeded)
   {
      updateAvailableMapList();
      updateMapContent();
      POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(RestartPopupTimerReqMsg)(AppHmi_NavigationModule_NavigationScenes_N_StreamedMap_SubOptions)));
   }

   return listUpdateNeeded;
}


void StreamedMapTypeSettingListHandler::updateAvailableMapList()
{
   _currentMapContent = 0;
   _availableMapType.clear();
   for (int itr = 0; itr < MAX_LIST_SIZE; itr++)
   {
      if (_stremMapTypeCheckboxValue[itr] == BUTTON_TOGGLE_ENABLED_TRUE)
      {
         _availableMapType.push_back(itr);
      }
   }
}


void StreamedMapTypeSettingListHandler::updateMapContent()
{
   Candera::UInt32 vectorSize = _availableMapType.size();
   if (_currentMapContent < vectorSize)
   {
      ETG_TRACE_USR4(("StreamedMapTypeSettingListHandler::updateMapContent(MapContent %d)", _availableMapType[_currentMapContent]));

      switch (_availableMapType[_currentMapContent])
      {
         case STREAMED_MAP_OPTION_OVERVIEW_MAP:
         {
            POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(SetMapCameraModeReqMsg)(STREAMED_MAP_OVERVIEW_MAP)));
            break;
         }
         case STREAMED_MAP_OPTION_2D_MAP:
         {
            POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(SetMapCameraModeReqMsg)(STREAMED_MAP_2D_MAP)));
            break;
         }
         case STREAMED_MAP_OPTION_3D_MAP:
         {
            POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(SetMapCameraModeReqMsg)(STREAMED_MAP_3D_MAP)));
            break;
         }
         default:
         {
            break;
         }
      }

      _currentMapContent = (_currentMapContent + 1) % vectorSize;
   }
   else
   {
      ETG_TRACE_USR4(("StreamedMapTypeSettingListHandler::updateMapContent(Map content cannot be set)"));
   }
}


#endif // HALL_TO_MDW_COM
