/**************************************************************************************
* @file         : StreamedMapSubOptionListHandler.h
* @author       :  ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef STREAM_MAP_SUB_OPTION_LIST_HANDLER_H
#define STREAM_MAP_SUB_OPTION_LIST_HANDLER_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"
#include "StreamedMapIconSettingListHandler.h"
#include "StreamedMapTypeSettingListHandler.h"
#include "StreamedMapContentSettingListHandler.h"
#include "StreamedMapPOISettingListHandler.h"
#include "AppHmi_NavigationStateMachine.h"


#ifdef HALL_TO_MDW_COM

class StreamedMapSubOptionListHandler : public NavMiddlewarePropertyUpdateConsumer, public ListImplementation
{
   public:
      StreamedMapSubOptionListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~StreamedMapSubOptionListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(ExpiredTimerResMsg)
      ON_COURIER_MESSAGE(ActivateStreamedMapSubOptionListReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      bool onCourierMessage(const ActivateStreamedMapSubOptionListReqMsg& oMsg);
      bool onCourierMessage(const ExpiredTimerResMsg& oMsg);

   private:
      enum StreamMapSettingsListItemValue
      {
         STREAMED_MAP_SETTING_DUARTION,
         STREAMED_MAP_SETTING_ICONS,
         STREAMED_MAP_SETTING_POI,
         STREAMED_MAP_SETTING_MAP_TYPE,
         STREAMED_MAP_SETTING_MAP_CONTENT,
      };
      //List Handler Objects for MapSettings Others Scene to Update the List
      StreamedMapIconSettingListHandler     _streamMapIconSettingListHandler;
      StreamedMapTypeSettingListHandler     _streamMapTypeListHandler;
      StreamedMapContentSettingListHandler  _streamMapContentListHandler;
      StreamedMapPOISettingListHandler      _streamMapPOIListHandler;

      Candera::UInt32 _activeMapStreamSettingsSceneListID;

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);

      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);

      FEATSTD_MAKE_CLASS_UNCOPYABLE(StreamedMapSubOptionListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // STREAM_MAP_SUB_OPTION_LIST_HANDLER_H
