/**************************************************************************************
* @file         : StreamedMapSubOptionListHandler.cpp
* @author       : ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include  <vector>
#include "StreamedMapSubOptionListHandler.h"
#include "MapSettingsOthersUtil.h"
#include "NaviSettingsUtil.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/StreamedMapSubOptionListHandler.cpp.trc.h"
#endif

#ifdef  HALL_TO_MDW_COM
using namespace navmiddleware;
static const int MAX_LIST_OTHERS_SIZE = 12;

StreamedMapSubOptionListHandler::StreamedMapSubOptionListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore)
   : NavMiddlewarePropertyUpdateConsumer(navMiddleware)
   , _streamMapIconSettingListHandler(navMiddleware, infoStore)
   , _streamMapTypeListHandler(navMiddleware, infoStore)
   , _streamMapContentListHandler(navMiddleware, infoStore)
   , _streamMapPOIListHandler(navMiddleware, infoStore)
   , _activeMapStreamSettingsSceneListID(STREAMED_MAP_SETTING_DUARTION)
{
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_STEAM_MAP_SUBOPTIONS, this);
}


StreamedMapSubOptionListHandler::~StreamedMapSubOptionListHandler()
{
}


void StreamedMapSubOptionListHandler::initialize()
{
   _streamMapIconSettingListHandler.initialize();
   _streamMapTypeListHandler.initialize();
   _streamMapContentListHandler.initialize();
   _streamMapPOIListHandler.initialize();
   _navMiddleware.registerMapPropertyUpdateCallback(*this);
}


void StreamedMapSubOptionListHandler::deinitialize()
{
   _streamMapIconSettingListHandler.deinitialize();
   _streamMapTypeListHandler.deinitialize();
   _streamMapContentListHandler.deinitialize();
   _streamMapPOIListHandler.deinitialize();
   _navMiddleware.unregisterMapPropertyUpdateCallback(*this);
}


tSharedPtrDataProvider StreamedMapSubOptionListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("StreamedMapSubOptionListHandler::getListDataProvider(ListID %d)", oMsg.GetListId()));

   unsigned int listId = oMsg.GetListId();
   unsigned int startIndex = oMsg.GetStartIndex();
   unsigned int windowElementSize = oMsg.GetWindowElementSize();
   tSharedPtrDataProvider dataProvider;

   if (LIST_ID_STEAM_MAP_SUBOPTIONS == listId)
   {
      switch (_activeMapStreamSettingsSceneListID)
      {
         case STREAMED_MAP_SETTING_ICONS:
         {
            dataProvider = _streamMapIconSettingListHandler.getListDataProvider(oMsg);
            break;
         }
         case STREAMED_MAP_SETTING_POI:
         {
            dataProvider = _streamMapPOIListHandler.getListDataProvider(oMsg);
            break;
         }
         case STREAMED_MAP_SETTING_MAP_TYPE:
         {
            dataProvider = _streamMapTypeListHandler.getListDataProvider(oMsg);
            break;
         }
         case STREAMED_MAP_SETTING_MAP_CONTENT:
         {
            dataProvider = _streamMapContentListHandler.getListDataProvider(oMsg);
            break;
         }
         default:
         {
            break;
         }
      }
   }
   return dataProvider;
}


bool StreamedMapSubOptionListHandler::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   bool isMsgConsumed = false;
   bool isListUpdate = true;
   Candera::UInt32 listId = oMsg.GetListId();
   unsigned int rowIdx = (unsigned int)oMsg.GetHdl();
   const enReaction  reaction = oMsg.GetReaction();
   if (LIST_ID_STEAM_MAP_SUBOPTIONS == listId)
   {
      if (enRelease == reaction)
      {
         ETG_TRACE_USR4(("StreamedMapSubOptionListHandler::onCourierMessage(ButtonListItemUpdMsg), List Id : %d, Row Id : %d", listId, rowIdx));
         switch (_activeMapStreamSettingsSceneListID)
         {
            case STREAMED_MAP_SETTING_ICONS:
            {
               isMsgConsumed = _streamMapIconSettingListHandler.handleButtonListItemUpdMsg(oMsg);
               break;
            }
            case STREAMED_MAP_SETTING_POI:
            {
               isMsgConsumed = _streamMapPOIListHandler.handleButtonListItemUpdMsg(oMsg);
               break;
            }
            case STREAMED_MAP_SETTING_MAP_TYPE:
            {
               isMsgConsumed = _streamMapTypeListHandler.handleButtonListItemUpdMsg(oMsg);
               break;
            }
            case STREAMED_MAP_SETTING_MAP_CONTENT:
            {
               isMsgConsumed = _streamMapContentListHandler.handleButtonListItemUpdMsg(oMsg);
               break;
            }
            default:
            {
               isListUpdate = false;
               break;
            }
         }

         if (true == isListUpdate)
         {
            ListRegistry::s_getInstance().updateList(LIST_ID_STEAM_MAP_SUBOPTIONS);
         }
      }
   }
   return isMsgConsumed;
}


bool StreamedMapSubOptionListHandler::onCourierMessage(const ActivateStreamedMapSubOptionListReqMsg& oMsg)
{
   ETG_TRACE_USR4(("StreamedMapSubOptionListHandler::ActivateStreamMapSubOptionListReqMsg()"));

   _activeMapStreamSettingsSceneListID = oMsg.GetSubOptionsListID();
   ListRegistry::s_getInstance().updateList(LIST_ID_STEAM_MAP_SUBOPTIONS);

   return true;
}


bool StreamedMapSubOptionListHandler::onCourierMessage(const ExpiredTimerResMsg& oMsg)
{
   ETG_TRACE_USR4(("StreamedMapSubOptionListHandler::ExpiredPopupTimerResMsg()"));

   _streamMapTypeListHandler.updateMapContent();

   return false;
}


#endif // HALL_TO_MDW_COM
