/**************************************************************************************
* @file         : StreamedMapSettingsListHandler.h
* @author       : ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef STREAMED_MAP_SETTINGS_LIST_HANDLER
#define STREAMED_MAP_SETTINGS_LIST_HANDLER

#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"

#if defined(HALL_TO_MDW_COM)

class StreamedMapSettingsListHandler : public HMIModelBase, public ListImplementation
{
   public:
      StreamedMapSettingsListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~StreamedMapSettingsListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(ExpiredTimerResMsg)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_END()

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      bool onCourierMessage(const ExpiredTimerResMsg& oMsg);

   private:

      enum StreamMapSettingsListItemValue
      {
         STREAMED_MAP_SETTING_DUARTION,
         STREAMED_MAP_SETTING_ICONS,
         STREAMED_MAP_SETTING_POI,
         STREAMED_MAP_SETTING_MAP_TYPE,
         STREAMED_MAP_SETTING_MAP_CONTENT,
      };

      enum StreamMapSettingsTimeListItemValue
      {
         STREAMED_MAP_30_SEC,
         STREAMED_MAP_40_SEC,
         STREAMED_MAP_50_SEC,
         STREAMED_MAP_60_SEC
      };

      Candera::UInt16 _timerDuration;
      //ToDo: To be reworked
      //IsButtonToggleEnabled _enableStreamMap;
      typedef ListItemBase<StreamMapSettingsListItemValue>  StreamMapSettingsListItem;
      std::vector<StreamMapSettingsListItem> _streamMapSettingsListItem;
      tSharedPtrDataProvider getMainListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider configureDropdownList(::Courier::UInt32 listID);
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      FEATSTD_MAKE_CLASS_UNCOPYABLE(StreamedMapSettingsListHandler);
      DataBindingItem<MultiLinePopuptextDataBindingSource> _PopupText;
      InfoStore& _infoStore;
      navmiddleware::NavMiddleware& _navMiddleware;
};


#endif // HALL_TO_MDW_COM
#endif // STREAMED_MAP_SETTINGS_LIST_HANDLER
