/**************************************************************************************
* @file         : StreamedMapPOISettingListHandler.h
* @author       :  ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef STREAMED_MAP_POI_SETTING_LIST_HANDLER_H
#define STREAMED_MAP_POI_SETTING_LIST_HANDLER_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"
#include "AppHmi_NavigationStateMachine.h"


#ifdef HALL_TO_MDW_COM

class StreamedMapPOISettingListHandler : public NavMiddlewarePropertyUpdateConsumer, public ListImplementation
{
   public:
      StreamedMapPOISettingListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~StreamedMapPOISettingListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      bool handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg);
      void updateMapContent();

   private:
      enum SettingsStreamMapPOI
      {
         STREAMED_MAP_POI_AIRPORT,
         STREAMED_MAP_POI_BANK,
         STREAMED_MAP_POI_HOSPITAL,
         STREAMED_MAP_POI_HOTEL,
         STREAMED_MAP_POI_PARKING,
         STREAMED_MAP_POI_RESTAURANT,
         STREAMED_MAP_POI_SHOPPING,
         STREAMED_MAP_POI_TRANSPORT
      };

      typedef ListItemBase<SettingsStreamMapPOI> StreamMapPOIListItem;
      std::vector<StreamMapPOIListItem> _streamMapPOIItemList;
      IsButtonToggleEnabled _streamMapPOICheckBoxValue[8];
      FEATSTD_MAKE_CLASS_UNCOPYABLE(StreamedMapPOISettingListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // STREAMED_MAP_POI_SETTING_LIST_HANDLER_H
