/**************************************************************************************
* @file         : StreamedMapIconSettingListHandler.h
* @author       :  ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef STREAMED_MAP_ICON_SETTING_LIST_HANDLER_H
#define STREAMED_MAP_ICON_SETTING_LIST_HANDLER_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"
#include "AppHmi_NavigationStateMachine.h"


#ifdef HALL_TO_MDW_COM

class StreamedMapIconSettingListHandler : public NavMiddlewarePropertyUpdateConsumer
{
   public:
      StreamedMapIconSettingListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~StreamedMapIconSettingListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      bool handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg);

   private:

      enum SettingsMapDisplayNames
      {
         STREAMED_MAP_OPTION_PLACE_NAMES,
         STREAMED_MAP_OPTION_FACILITY_NAMES,
         STREAMED_MAP_OPTION_ROAD_NAMES,
         STREAMED_MAP_OPTION_INTERSECTION_NAMES
      };

      typedef ListItemBase<SettingsMapDisplayNames> StreamMapDisplayListItem;
      std::vector<StreamMapDisplayListItem> _streamMapDisplayItemList;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(StreamedMapIconSettingListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // STREAMED_MAP_ICON_SETTING_LIST_HANDLER_H
