/**************************************************************************************
* @file         : StreamedMapContentSettingListHandler.cpp
* @author       : ECG-NAveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include  <vector>
#include "StreamedMapContentSettingListHandler.h"
#include "MapSettingsOthersUtil.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/StreamedMapContentSettingListHandler.cpp.trc.h"
#endif

#ifdef  HALL_TO_MDW_COM

static const Candera::UInt8 MAX_LIST_SIZE = 4;
StreamedMapContentSettingListHandler::StreamedMapContentSettingListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore)
   : NavMiddlewarePropertyUpdateConsumer(navMiddleware)
{
   // configuring static list item
   for (int itr = 0; itr < MAX_LIST_SIZE; itr++)
   {
      _streamMapContentCheckBoxValue[itr] = BUTTON_TOGGLE_ENABLED_FALSE;
   }
}


StreamedMapContentSettingListHandler::~StreamedMapContentSettingListHandler()
{
}


void StreamedMapContentSettingListHandler::initialize()
{
   Candera::UInt8 MAX_LIST_SIZE = 4;
   _streamMapContentItemList.reserve(MAX_LIST_SIZE);
   _streamMapContentItemList.push_back(StreamMapContentListItem(LANGUAGE_STRING(TextId_0x1419, "Latitude"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_OPTION_LATITUDE));
   _streamMapContentItemList.push_back(StreamMapContentListItem(LANGUAGE_STRING(TextId_0x141A, "Longtitude"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_OPTION_LONGTITUDE));
   _streamMapContentItemList.push_back(StreamMapContentListItem(LANGUAGE_STRING(TextId_0x060B, "Speed"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_SPEED));
   _streamMapContentItemList.push_back(StreamMapContentListItem(LANGUAGE_STRING(TextId_0x149F, "Next Major Station"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_NEXT_MAJOR_STATION));
}


void StreamedMapContentSettingListHandler::deinitialize()
{
}


tSharedPtrDataProvider StreamedMapContentSettingListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("StreamedMapContentSettingListHandler::getListDataProvider(List ID %d)", oMsg.GetListId()));

   DataItemContext  listItemName = "Layer_Checkbox";
   Candera::UInt32 listID = oMsg.GetListId();
   ListDataProviderBuilder listBuilder(listID);
   Candera::UInt8 checkBoxIdx = 0;

   for (std::vector<StreamMapContentListItem>::iterator itemNumber = _streamMapContentItemList.begin(); ((itemNumber < _streamMapContentItemList.end()) && (checkBoxIdx < MAX_LIST_SIZE)); ++itemNumber, ++checkBoxIdx)
   {
      if (itemNumber->_listButtonType == LIST_BUTTON_TYPE_TOGGLE)
      {
         listBuilder.AddItem(
            itemNumber->_order,
            0UL,  //    - unused
            listItemName)  //0 - Name(Id) of the button
         .AddData(itemNumber->_text)
         .AddData(_streamMapContentCheckBoxValue[checkBoxIdx])
         .AddData(itemNumber->_isVisible);
      }
   }

   return listBuilder.CreateDataProvider();
}


bool StreamedMapContentSettingListHandler::handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg)
{
   navmiddleware::settings::MapTextFilterSettings mapTextFilterSettings = _navMiddleware.getMapTextFilterSettings();
   ETG_TRACE_USR4(("StreamedMapContentSettingListHandler::handleButtonListItemUpdMsg(%d)", oMsg.GetHdl()));

   bool listUpdateNeeded = true;
   Candera::UInt32 listId = oMsg.GetListId();
   unsigned int rowID = (unsigned int)oMsg.GetHdl();
   const enReaction  reaction = oMsg.GetReaction();

   if ((LIST_ID_STEAM_MAP_SUBOPTIONS == listId) && (enRelease == reaction))
   {
      switch (rowID)
      {
         case STREAMED_MAP_OPTION_LATITUDE:
         {
            _streamMapContentCheckBoxValue[STREAMED_MAP_OPTION_LATITUDE] = toggleCheckbox(_streamMapContentCheckBoxValue[STREAMED_MAP_OPTION_LATITUDE]);
            //TO DO: Middleware calls to update the settings of  Streamed Map Content should be updated
            break;
         }
         case STREAMED_MAP_OPTION_LONGTITUDE:
         {
            _streamMapContentCheckBoxValue[STREAMED_MAP_OPTION_LONGTITUDE] = toggleCheckbox(_streamMapContentCheckBoxValue[STREAMED_MAP_OPTION_LONGTITUDE]);
            //TO DO: Middleware calls to update the settings of  Streamed Map Content should be updated
            break;
         }
         case STREAMED_MAP_SPEED: // Road _Names
         {
            _streamMapContentCheckBoxValue[STREAMED_MAP_SPEED] = toggleCheckbox(_streamMapContentCheckBoxValue[STREAMED_MAP_SPEED]);
            //TO DO: Middleware calls to update the settings of  Streamed Map Content should be updated
            break;
         }
         case STREAMED_MAP_NEXT_MAJOR_STATION: // Road _Names
         {
            _streamMapContentCheckBoxValue[STREAMED_MAP_NEXT_MAJOR_STATION] = toggleCheckbox(_streamMapContentCheckBoxValue[STREAMED_MAP_NEXT_MAJOR_STATION]);
            //TO DO: Middleware calls to update the settings of  Streamed Map Content should be updated
            break;
         }
         default:
         {
            listUpdateNeeded = false;
            break;
         }
      }
   }

   if (listUpdateNeeded)
   {
      //TO DO Middleware calls to update the Map Content setting should be updated
   }

   return listUpdateNeeded;
}


#endif // HALL_TO_MDW_COM
