/**************************************************************************************
* @file         : SpeedLimitSettingsListHandler.h
* @author       : ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef SPEED_LIMIT_SETTING_LIST_HANDLER_H
#define SPEED_LIMIT_SETTING_LIST_HANDLER_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"

#ifdef HALL_TO_MDW_COM

class SpeedLimitSettingsListHandler : public NavMiddlewarePropertyUpdateConsumer, public ListImplementation
{
   public:
      SpeedLimitSettingsListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~SpeedLimitSettingsListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(ApplyMapViewSettingsReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      bool onCourierMessage(const ApplyMapViewSettingsReqMsg& oMsg);

   private:
      unsigned int _listId;
      unsigned int _startIndex;
      unsigned int _windowElementSize;

      enum SpeedLimitListItemValue
      {
      #ifdef ENABLE_FEATURE_SPEED_LIMIT
         SETTING_SPEED_LIMIT_SENSITIVITY,
         SETTING_SPEED_LIMIT_INDICATION_ON_MAP,
         SETTING_SPEED_LIMIT_WARNING,
      #endif
         SETTING_VEHICLE_RESTRICTIONS_WARNING
      };

      enum TrafficFequencyListItemValue
      {
         DO_NOT_UPDATE,
         TWO_MINS_ONCE,
         FIVE_MINS_ONCE,
         TEN_MINS_ONCE,
         THIRTY_MINS_ONCE,
         SIXTY_MINS_ONCE
      };

      enum GuidanceViewInfoSettingsListItemValue
      {
         LEFTSIDE_INFO_INTERSECTION,
         LEFTSIDE_INFO_FULLMAP
      };

      typedef ListItemBase<SpeedLimitListItemValue> SpeedLimitListItem;
      std::vector<SpeedLimitListItem> _speedLimitOptionsList;

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getListDataProviderMainList();
   #ifdef ENABLE_FEATURE_SPEED_LIMIT
      void increaseSpeedLimitSensitivity(navmiddleware::settings::SafetyGuidanceSettings& safetyGuidanceSettings);
      void decreaseSpeedLimitSensitivity(navmiddleware::settings::SafetyGuidanceSettings& safetyGuidanceSettings);
   #endif
      /*void changeLeftSideInfoSettings(Candera::UInt32 selectedRowId);
       void onPropertyMapRepresentaionModeChanged();*/
      FEATSTD_MAKE_CLASS_UNCOPYABLE(SpeedLimitSettingsListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // SPEED_LIMIT_SETTING_LIST_HANDLER_H
