/**************************************************************************************
* @file         : SettingsTrackingDotsDisplayedOnMapListHandler.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef SETTINGS_TRACKING_DOTS_DISPLAYED_LIST_HANDLER
#define SETTINGS_TRACKING_DOTS_DISPLAYED_LIST_HANDLER

#include "../Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"

#if defined(HALL_TO_MDW_COM)

class SettingsTrackingDotsDisplayedListHandler : public HMIModelBase
{
   public:
      SettingsTrackingDotsDisplayedListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~SettingsTrackingDotsDisplayedListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      bool handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg);

   private:
      void ShowICPopUpForDeleteTrackingPoints();

      enum SettingsTrackingDotsDisplayedListItemValue
      {
         SETTINGS_TRACKING_DOTS_DISPLAYED_LIST_ITEM_SHOW_TRACKING_DOTS_ON_MAP,
         SETTINGS_TRACKING_DOTS_DISPLAYED_LIST_ITEM_DIST_BTW_TRACKING_DOTS,
         SETTINGS_TRACKING_DOTS_DISPLAYED_LIST_ITEM_DELETE_TRACK_TO_CURRENT_LOCATION
      };

      typedef ListItemBase<SettingsTrackingDotsDisplayedListItemValue> SettingsTrackingDotsDisplayedListItem;
      std::vector<SettingsTrackingDotsDisplayedListItem> _settingsTrackingDotsDisplayedList;
      bool changeTrackingDotsDisatance(Candera::UInt32 selectedRowId);
      unsigned int getTrackingDotsDistanceValue(navmiddleware::NavMiddleware& navMiddleware);
      void processComboBox(Courier::UInt32 hdl, Courier::UInt32 subHdl);

      FEATSTD_MAKE_CLASS_UNCOPYABLE(SettingsTrackingDotsDisplayedListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // SETTINGS_TRACKING_DOTS_DISPLAYED_LIST_HANDLER
