/**************************************************************************************
* @file         : RoutePreferenceListHandler.h
* @author       : ECG-Ramesh Kesavan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef ROUTE_PREFERENCE_LIST_HANDLER_H
#define ROUTE_PREFERENCE_LIST_HANDLER_H

#include "AppHmi_NavigationStateMachine.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"
#include "NaviSettingsUtil.h"

#ifdef HALL_TO_MDW_COM

class RoutePreferenceListHandler : public InfoStorePropertyUpdateConsumer , public NavMiddlewarePropertyUpdateConsumer, public ListImplementation
{
   public:
      RoutePreferenceListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~RoutePreferenceListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from Infostore
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ApplyRoutePreferenceOptionsReqMsg)
      ON_COURIER_MESSAGE(ChangeRouteTypeItemReqMsg)
      ON_COURIER_MESSAGE(ChangeCustomRouteItemReqMsg)
      ON_COURIER_MESSAGE(ChangeEstimatedTimeItemReqMsg)
      ON_COURIER_MESSAGE(ChangeTimeOnMapItemReqMsg)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      // Courier messages are received from other components (usually View and Controller (StateMachine)).
      virtual bool onCourierMessage(const ApplyRoutePreferenceOptionsReqMsg& oMsg);
      virtual bool onCourierMessage(const ChangeRouteTypeItemReqMsg& oMsg);
      virtual bool onCourierMessage(const ChangeCustomRouteItemReqMsg& oMsg);
      virtual bool onCourierMessage(const ChangeEstimatedTimeItemReqMsg& oMsg);
      virtual bool onCourierMessage(const ChangeTimeOnMapItemReqMsg& oMsg);
      virtual bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);

   private:
      bool _isDropdownEnabled;
      bool _routeType[MAX_SIZE_ROUTE_TYPE];
      bool _customisedRoute[MAX_SIZE_CUSTOM_ROUTE_OPTION];
      bool _estimatedTime[MAX_SIZE_ESTIMATED_TIME];
      bool _timeOnMap[MAX_SIZE_TIME_ON_MAP];
      unsigned int _listId;

      enRouteTypeOptions _currentRouteOption;
      enCustomizeRouteOptions _currentCustomRouteOption;
      enEstimatedTimeOptions _currentEstimatedTimeOption;
      enTimeOnMapOptions _currentTimeOnMapOption;

      Candera::String _currentRouteOptionStr;
      Candera::String _currentCustomRouteOptionStr;
      Candera::String _currentEstimatedTimeStr;
      Candera::String _currentTimeOnMapStr;

      Candera::String getRouteCondition(navmiddleware::NavMiddleware& navMiddleware);
      Candera::String getRouteCalculationType(navmiddleware::NavMiddleware& navMiddleware);
      Candera::String getEstimatedTimeOption();
      Candera::String getTimeOnMapOption();
      void setRouteCalculationType() const;
      void setRouteType();
      void resetSelectedOption();
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      FEATSTD_MAKE_CLASS_UNCOPYABLE(RoutePreferenceListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // ROUTE_PREFERENCE_LIST_HANDLER_H
