/**************************************************************************************
* @file         : PremiumTrafficListHandler.h
* @author       : ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef PREMIUM_TRAFFIC_LIST_HANDLER_H
#define PREMIUM_TRAFFIC_LIST_HANDLER_H

#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"

#ifdef HALL_TO_MDW_COM

class PremiumTrafficListHandler : public NavMiddlewarePropertyUpdateConsumer, public InfoStorePropertyUpdateConsumer, public ListImplementation
{
   public:
      PremiumTrafficListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~PremiumTrafficListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_BT_CONNECTED_DEVICE_CHANGED, onPropertyUpdateBTConnectionChanged);
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(FetchPremiumTrafficSettingsReqMsg)
      ON_COURIER_MESSAGE(ApplyPremiumTrafficSettingsReqMsg)
      ON_COURIER_MESSAGE(ApplySettingsReqMsg)
      ON_COURIER_MESSAGE(PANConnectionStatusMsg)
      ON_COURIER_MESSAGE(PANConnectionTimerExpiredMsg)
      ON_COURIER_MESSAGE(PANPollingTimerExpiredMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      bool onCourierMessage(const FetchPremiumTrafficSettingsReqMsg& oMsg);
      bool onCourierMessage(const ApplyPremiumTrafficSettingsReqMsg& oMsg);
      bool onCourierMessage(const ApplySettingsReqMsg& oMsg);
      bool onCourierMessage(const PANConnectionStatusMsg& oMsg);
      bool onCourierMessage(const PANConnectionTimerExpiredMsg& oMsg);
      bool onCourierMessage(const PANPollingTimerExpiredMsg& oMsg);

      bool onPropertyUpdateBTConnectionChanged();

   private:
      enum PremiumTrafficListItemValue
      {
         SETTING_ENABLE_PREMIUM_TRAFFIC,
         SETTING_UPDATE_FOR_EACH_ROUTE,
         SETTING_UPDATE_FREQUENCY
      };
      enum TrafficFequencyListItemValue
      {
         DO_NOT_UPDATE,
         TWO_MINS_ONCE,
         FIVE_MINS_ONCE,
         TEN_MINS_ONCE,
         THIRTY_MINS_ONCE,
         SIXTY_MINS_ONCE
      };
      enum BTTetheringState
      {
         BT_TETHERING_STATE__NotApplicable    = 0,
         BT_TETHERING_STATE__NoPhoneConnected = 1,
         BT_TETHERING_STATE__InProgress       = 2,
         BT_TETHERING_STATE__Success          = 3
      };

      typedef ListItemBase<PremiumTrafficListItemValue> PremiumTrafficListItem;
      std::vector<PremiumTrafficListItem> _premiumTrafficList;
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getListDataProviderMainList();
      tSharedPtrDataProvider configureDropdownList(::Courier::UInt32 currentListID);

      void applySettings();
      void changePremiumTrafficUpdateFrequency(Candera::UInt32 selectedRowId);
      int getUpdateFrequencyIndex();
      int getUpdateFrequency();

      void setBTTetheringState(BTTetheringState tetheringState);
      void setPremiumTrafficState(bool premiumTrafficState);
      void setPrivacyMode(bool privacyMode);
      void startPANConnection();
      void stopPANConnection();
      void stopPANTimers();

      Util::Timer _panConnectionTimer;
      Util::Timer _panPollingTimer;
      ::navmiddleware::settings::TrafficSettings _trafficSettings;
      DataBindingItem<BTTetheringStateDataBindingSource> _btTetheringStateData;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(PremiumTrafficListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // PREMIUM_TRAFFIC_LIST_HANDLER_H
