/**************************************************************************************
* @file         : PositionInfoDataUtils.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef POSITION_INFO_DATA_UTILS_H
#define POSITION_INFO_DATA_UTILS_H

#include "Common/Util/HMIModelIncludes.h"

#if defined(HALL_TO_MDW_COM)

/**
* Sets the vehicle's currrent latitude, longitide, altitude info
*/
void setGpsSensorInfos(const navmiddleware::GnssDataInfo& gnssDataInfo, navmiddleware::DateFormat& dateFormat);
void setGpsSensorlatlongInfos(const navmiddleware::GnssDataInfo& gnssDataInfo, bool isDayModeActive, bool isDemoModeActive);
void setSatelliteIconVisibility(const navmiddleware::GnssDataInfo& gnssDataInfo, bool isDayModeActive, bool isDemoModeActive);
void setSatelliteIcon(bool isDayModeActive);

/**
* Sets the vehicle's current street, current city info
*/
void setWhereAmIScreenDataWhereAmIStatusInfos(const navmiddleware::WhereAmIInfo& whereAmIInfo);
void updateDateBasedonFormat(const std::string& day, const std::string& month, const std::string& year, navmiddleware::DateFormat& dateFormat);

bool sendGpsInfoData(void);

bool sendWhereAmIScreenData(void);

float convertHeadingIndexToHeading(int headingIndex);

int convertHeadingToHeadingIndex(float heading);

#endif // HALL_TO_MDW_COM
#endif // _POSITION_INFO_DATA_UTILS_H
