/**************************************************************************************
* @file         : MapSettingsTextListHandler.h
* @author       : ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef MAP_SETTINGS_TEXTTODISPLAY_LIST_HANDLER
#define MAP_SETTINGS_TEXTTODISPLAY_LIST_HANDLER

#include "../Common/Util/HMIModelIncludes.h"

#if defined(HALL_TO_MDW_COM)

class MapSettingsTextListHandler : public HMIModelBase
{
   public:
      MapSettingsTextListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~MapSettingsTextListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      bool handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg);

   private:
      enum SettingsMapTextListItemValue
      {
         SETTINGS_MAP_TEXT_LIST_ITEM_PLACE_NAMES,
         SETTINGS_MAP_TEXT_LIST_ITEM_FACILITY_NAMES,
         SETTINGS_MAP_TEXT_LIST_ITEM_ROAD_NAMES,
         SETTINGS_MAP_TEXT_LIST_ITEM_INTERSECTION_NAMES
      };

      typedef ListItemBase<SettingsMapTextListItemValue> SettingsMapTextListItem;
      std::vector<SettingsMapTextListItem> _settingsMapTextList;
      bool getListItemStatus(SettingsMapTextListItemValue listItemValue) const;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(MapSettingsTextListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // MAP_SETTINGS_TEXTTODISPLAY_LIST_HANDLER
