/**************************************************************************************
* @file         : MapSettingsTextListHandler.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include <vector>
#include "MapSettingsTextListHandler.h"
#include "MapSettingsOthersUtil.h"
#include "Common/DataModel/ListRegistry.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/MapSettingsTextListHandler.cpp.trc.h"
#endif

#if defined (HALL_TO_MDW_COM)


MapSettingsTextListHandler::MapSettingsTextListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore)
   : HMIModelBase(navMiddleware, infoStore)
{
}


MapSettingsTextListHandler::~MapSettingsTextListHandler()
{
}


void MapSettingsTextListHandler::initialize()
{
   Candera::UInt8 MAX_LIST_SIZE = 3;
   _settingsMapTextList.reserve(MAX_LIST_SIZE);
   _settingsMapTextList.push_back(SettingsMapTextListItem(LANGUAGE_STRING(TextId_0x13F5, "Place names"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, SETTINGS_MAP_TEXT_LIST_ITEM_PLACE_NAMES, getPlaceNames));
   _settingsMapTextList.push_back(SettingsMapTextListItem(LANGUAGE_STRING(TextId_0x13F6, "Facility names"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, SETTINGS_MAP_TEXT_LIST_ITEM_FACILITY_NAMES, getFacilityNames));
   _settingsMapTextList.push_back(SettingsMapTextListItem(LANGUAGE_STRING(TextId_0x13F7, "Road names"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, SETTINGS_MAP_TEXT_LIST_ITEM_ROAD_NAMES, getRoadNames));
}


void MapSettingsTextListHandler::deinitialize()
{
}


bool MapSettingsTextListHandler::handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg)
{
   bool bIsMsgConsumed = false;
   Candera::UInt32 listId = oMsg.GetListId();
   unsigned int rowID = (unsigned int)oMsg.GetHdl();
   const enReaction  reaction = oMsg.GetReaction();

   if ((LIST_ID_MAP_SETTINGS_OTHERS == listId) && (enRelease == reaction))
   {
      ETG_TRACE_USR4(("MapSettingsTextListHandler::handleButtonListItemUpdMsg(ButtonListItemUpdMsg), List Id : %d, Row Id : %d", listId, rowID));
      bool listUpdateNeeded = true;
      navmiddleware::settings::MapTextFilterSettings mapTextFilterSettings = _navMiddleware.getMapTextFilterSettings();

      switch (rowID)
      {
         case SETTINGS_MAP_TEXT_LIST_ITEM_PLACE_NAMES:
         {
            mapTextFilterSettings.setPlaceNameFilter(!mapTextFilterSettings.isPlaceNameFilterEnabled());
            break;
         }
         case SETTINGS_MAP_TEXT_LIST_ITEM_FACILITY_NAMES:
         {
            mapTextFilterSettings.setFacilityNameFilter(!mapTextFilterSettings.isFacilityNameFilterEnabled());
            break;
         }
         case SETTINGS_MAP_TEXT_LIST_ITEM_ROAD_NAMES: // Road _Names
         {
            mapTextFilterSettings.setRoadNameFilter(!mapTextFilterSettings.isRoadNameFilterEnabled());
            break;
         }
         case SETTINGS_MAP_TEXT_LIST_ITEM_INTERSECTION_NAMES:
         {
            mapTextFilterSettings.setIntersectionNameFilter(!mapTextFilterSettings.getIntersectionNameFilter());
            break;
         }
         default:
         {
            listUpdateNeeded = false;
            break;
         }
      }
      if (listUpdateNeeded)
      {
         _navMiddleware.updateMapTextFilterSettings(mapTextFilterSettings);
         ListRegistry::s_getInstance().updateList(LIST_ID_MAP_SETTINGS_OTHERS);
      }
      bIsMsgConsumed = true;
   }

   return bIsMsgConsumed;
}


tSharedPtrDataProvider MapSettingsTextListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("MapSettingsTextListHandler::getListDataProvider(List ID %d)", oMsg.GetListId()));
   DataItemContext  listItemName = "Layer_Checkbox";
   Candera::UInt32 listID = oMsg.GetListId();
   ListDataProviderBuilder listBuilder(listID);

   for (std::vector<SettingsMapTextListItem>::iterator itemNumber = _settingsMapTextList.begin(); itemNumber < _settingsMapTextList.end(); ++itemNumber)
   {
      if (itemNumber->_listButtonType == LIST_BUTTON_TYPE_TOGGLE)
      {
         listBuilder.AddItem(
            itemNumber->_order,
            0UL,  //    - unused
            listItemName)  //0 - Name(Id) of the button
         .AddData(itemNumber->_text)
         .AddData(itemNumber->getButtonToggleState(_navMiddleware))
         .AddData(itemNumber->_isVisible);
      }
   }

   return listBuilder.CreateDataProvider();
}


#endif // HALL_TO_MDW_COM
