/**************************************************************************************
* @file         : MapSettingsShowPOIListHandler.h
* @author       : ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef MAPSETTINGS_SHOWPOI_LIST_HANDLER
#define MAPSETTINGS_SHOWPOI_LIST_HANDLER

#include "Common/Util/HMIModelIncludes.h"

#if defined(HALL_TO_MDW_COM)

class MapSettingsShowPOIListHandler : public HMIModelBase
{
   public:
      MapSettingsShowPOIListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~MapSettingsShowPOIListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE_NOTRACE(ShowPoisOnMapViewReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(ButtonListItemUpdMsg)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_MAP_DELEGATE_END()

      bool onCourierMessage(const ShowPoisOnMapViewReqMsg& oMsg);
      bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);

   private:
      void toggleStatusUpdateToMDW(const unsigned int& selectedRowId);
      void updateMapDynamicIconSettingsList();
      tSharedPtrDataProvider getMapDynamicIconSelectionList() const;

      unsigned int _startIndex;
      unsigned int _windowElementSize;
      unsigned int _listId;
      navmiddleware::settings::MapDynamicIconSettings _mapDynamicIconSettings;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(MapSettingsShowPOIListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // MAPSETTINGS_SHOWPOI_LIST_HANDLER
