/**************************************************************************************
* @file         : MapSettingsOthersListHandler.h
* @author       :  ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef MAP_SETTINGS_OTHERS_LIST_HANDLER_H
#define MAP_SETTINGS_OTHERS_LIST_HANDLER_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"
#include "MapSettingsLeftSplitMapListHandler.h"
#include "MapColorStyleListHandler.h"
#include "MapSettingsTextListHandler.h"
#include "SettingsTrackingDotsDisplayedOnMapListHandler.h"
#include "SettingsMapScrollingInfoListHandler.h"
#include "AppHmi_NavigationStateMachine.h"


#ifdef HALL_TO_MDW_COM

class MapSettingsOthersListHandler : public NavMiddlewarePropertyUpdateConsumer, public ListImplementation
{
   public:
      MapSettingsOthersListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~MapSettingsOthersListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_PRESENTATION_MODE_CHANGED, onPropertyMapPresentationModeChanged);
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(ActivateOthersMapSettingListReqMsg)
      ON_COURIER_MESSAGE(DeleteTrackingPointReqMsg)
      ON_COURIER_MESSAGE(LeftMapViewSetMapScaleReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      bool onCourierMessage(const LeftMapViewSetMapScaleReqMsg& oMsg);
      bool onCourierMessage(const ActivateOthersMapSettingListReqMsg& oMsg);
      bool onCourierMessage(const ApplyMapViewSettingsReqMsg& oMsg);
      bool onCourierMessage(const DeleteTrackingPointReqMsg& oMsg);

   private:
      unsigned int _listId;

      enum HierarchyLevel
      {
         LEVEL_ONE,
         LEVEL_TWO
      };

      //List Handler Objects for MapSettings Others Scene to Update the List
      MapSettingsLeftSplitMapListHandler _mapSettingsLeftSplitMapListHandler;
      MapSettingsTextListHandler _mapSettingsTextListHandler;
      SettingsTrackingDotsDisplayedListHandler _mapSettingsTrackingDotsListHandler;
      SettingsMapScrollingInfoListHandler _mapSettingsScrollingInfoListHandler;

      Candera::UInt8 _currentHierarchyLevel;
      Candera::UInt32 _activeMapSettingsOtherListID;
      typedef ListItemBase<enMapSettingOptionOthers> MapSettingsListItem;
      std::vector<MapSettingsListItem> _mapSettingsList;
      DataBindingItem<MapSettingsOthersTitleDataBindingSource> _mapSettingsOthersTitle;
      DataBindingItem<TwoLinePopuptextDataBindingSource>_deleteDestinationText;
      DataBindingItem<MapSettingOthersListIDDataBindingSource>_mapSettingOtherListIDData;
      DataBindingItem<MapOptionOthersSettingDataBindingSource> _mapOptionOthersSettingData;

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      bool changeMapTextStyle(Candera::UInt32 selectedRowId);
      bool changeMapOrientationSettings(Candera::UInt32 selectedRowId);
      void changeBackButtonBG();
      void updateSceneTitle(Candera::UInt32 selectedRow);
      bool handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg);
      void onPropertyMapPresentationModeChanged();
      void processComboBox(Courier::UInt32 hdl, Courier::UInt32 subHdl);
      unsigned int getMapTextSize();

      FEATSTD_MAKE_CLASS_UNCOPYABLE(MapSettingsOthersListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // MAP_SETTINGS_OTHERS_LIST_HANDLER_H
