/**************************************************************************************
* @file         : DestinationLatLongSpellerHandler.cpp
* @author       : ECG-Ramesh Kesavan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include  <vector>
#include "MapSettingsOthersListHandler.h"
#include "MapSettingsOthersUtil.h"
#include "NaviSettingsUtil.h"
#include "NaviSettingsUtil.h"


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/MapSettingsOthersListHandler.cpp.trc.h"
#endif

#define NUMBER_OF_MAP_SETTING_OTHER_CHECKBOX_ITEMS 2

#ifdef  HALL_TO_MDW_COM

static const int MAX_LIST_OTHERS_SIZE = 12;
static const char* const DATA_CONTEXT_TEXT_LIST_ITEM = "Layer_ListButton";
static const char* const DATA_CONTEXT_COMBOBOX_LIST_ITEMS_2 = "ComboBox_ListItem2";
static const char* const DATA_CONTEXT_COMBOBOX_LIST_ITEMS_3 = "ComboBox_ListItem3";
static const char* const DATA_CONTEXT_ROUTE_SETTINGS_TOGGLE_OPTION = "Layer_Checkbox";

MapSettingsOthersListHandler::MapSettingsOthersListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore)
   : NavMiddlewarePropertyUpdateConsumer(navMiddleware)
   , _mapSettingsLeftSplitMapListHandler(navMiddleware, infoStore)
   , _mapSettingsTextListHandler(navMiddleware, infoStore)
   , _mapSettingsTrackingDotsListHandler(navMiddleware, infoStore)
   , _mapSettingsScrollingInfoListHandler(navMiddleware, infoStore)
   , _activeMapSettingsOtherListID(0)
   , _currentHierarchyLevel(0)
{
   // configuring static list item

   _listId = LIST_ID_MAP_SETTINGS_OTHERS;

   ListRegistry::s_getInstance().addListImplementation(LIST_ID_MAP_SETTINGS_OTHERS, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_DROPDOWN_TRACKING_DOT_DISTANCE, this);
}


MapSettingsOthersListHandler::~MapSettingsOthersListHandler()
{
}


void MapSettingsOthersListHandler::initialize()
{
   _mapSettingsTextListHandler.initialize();
   _mapSettingsTrackingDotsListHandler.initialize();
   _mapSettingsScrollingInfoListHandler.initialize();
   _mapSettingsLeftSplitMapListHandler.initialize();
   _navMiddleware.registerMapPropertyUpdateCallback(*this);

   unsigned int currentMapOrientationOption = 0;
   unsigned int currentTextStyleOption = 0;
   Candera::String currentMapOrientationStr = "";
   Candera::String currentMapTextStyleStr = "";

   currentMapOrientationOption = static_cast<unsigned int>((_navMiddleware.getMapSettings().getMapOrientation()) - 1);
   currentMapOrientationStr = MapOrientaionDropDownListLabel[currentMapOrientationOption];
   currentTextStyleOption = getMapTextSize();
   currentMapTextStyleStr = MapTextSizeListLabel[currentTextStyleOption];

   _mapSettingsList.reserve(MAX_LIST_OTHERS_SIZE);
   _mapSettingsList.push_back(MapSettingsListItem(LANGUAGE_STRING(TextId_0x0365, "Map orientation"), IS_VISIBLE_TRUE,
                              LIST_BUTTON_TYPE_DROPDOWN, MAP_SETTINGS_MAP_ORIENTATION,
                              currentMapOrientationStr, LIST_ID_DROPDOWN_MAP_ORIENTATION));
   _mapSettingsList.push_back(MapSettingsListItem(LANGUAGE_STRING(TextId_0x13F8, "Left split map settings"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_BUTTON, MAP_SETTINGS_LEFT_SPLIT_MAP));
   _mapSettingsList.push_back(MapSettingsListItem(LANGUAGE_STRING(TextId_0x13F3, "Map text size"), IS_VISIBLE_TRUE,
                              LIST_BUTTON_TYPE_DROPDOWN, MAP_SETTINGS_MAP_TEXT_SIZE,
                              currentMapTextStyleStr, LIST_ID_DROPDOWN_MAP_TEXT_SIZE));
   _mapSettingsList.push_back(MapSettingsListItem(LANGUAGE_STRING(TextId_0x13F2, "Map color"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_BUTTON, MAP_SETTINGS_MAP_COLOR));
   _mapSettingsList.push_back(MapSettingsListItem(LANGUAGE_STRING(TextId_0x13F4, "Select text to display on map"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_BUTTON, MAP_SETTINGS_DISPLAY_TEXT));
   _mapSettingsList.push_back(MapSettingsListItem(LANGUAGE_STRING(TextId_0x1405, "Map scrolling information"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_BUTTON, MAP_SETTINGS_MAP_SCROLLING_INFO));
   _mapSettingsList.push_back(MapSettingsListItem(LANGUAGE_STRING(TextId_0x1409, "Tracking dots displayed on map"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_BUTTON, MAP_SETTINGS_TRACKING_DOTS));
   _mapSettingsList.push_back(MapSettingsListItem(LANGUAGE_STRING(TextId_0x13F1, "Long range"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, MAP_SETTINGS_LONG_RANGE, getLongRange));
   /* _mapSettingsList.push_back(MapSettingsListItem(LANGUAGE_STRING(TEXTID_UNAVAILABLE, "Show all freeway exit on route"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, MAP_SETTINGS_SHOW_ALL_FREEWAY_EXIT, getFreewayExitOnRoute));
    _mapSettingsList.push_back(MapSettingsListItem(LANGUAGE_STRING(TEXTID_UNAVAILABLE, "Auto : show turn list on freeway"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, MAP_SETTINGS_SHOW_TURN_LIST, getAutoTurnList));
    _mapSettingsList.push_back(MapSettingsListItem(LANGUAGE_STRING(TextId_IT_00700, "North up when zoomed out"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, MAP_SETTINGS_NORTH_UP_WHEN_ZOOMED, getNorthUPWhenZoomedOut));*/
   _mapSettingsList.push_back(MapSettingsListItem(LANGUAGE_STRING(TextId_0x1436, "Auto zoom"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, MAP_SETTINGS_AUTO_ZOOM, getAutoZoom));
}


void MapSettingsOthersListHandler::deinitialize()
{
   _mapSettingsLeftSplitMapListHandler.deinitialize();
   _mapSettingsTextListHandler.deinitialize();
   _mapSettingsTrackingDotsListHandler.deinitialize();
   _mapSettingsScrollingInfoListHandler.deinitialize();
   _navMiddleware.unregisterMapPropertyUpdateCallback(*this);
}


tSharedPtrDataProvider MapSettingsOthersListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   _listId = oMsg.GetListId();
   tSharedPtrDataProvider dataProvider;

   switch (_activeMapSettingsOtherListID)
   {
      case MAP_SETTINGS_OTHERS_MAIN:
      {
         if (LIST_ID_MAP_SETTINGS_OTHERS == _listId)
         {
            const Candera::UInt8 INVALID_VALUE = 0xFF;
            updateSceneTitle(INVALID_VALUE);
            unsigned int currentMapOrientationOption = 0;
            unsigned int currentTextStyleOption = 0;
            Candera::String currentMapOrientationStr = "";
            Candera::String currentMapTextStyleStr = "";
            bool orientationtype[MAX_SIZE_MAPORIENTAION_DROPDOWN] = {false};
            bool textStyleType[MAX_SIZE_MAP_TEXT] = {false};
            bool isCheckboxEnabled[NUMBER_OF_MAP_SETTING_OTHER_CHECKBOX_ITEMS] = {false};
            navmiddleware::settings::MapView currentMapView = _navMiddleware.getChangeMapViewSettings().getMapView();
            IsVisible leftSplitMapSettingsDisabled = IS_VISIBLE_TRUE;
            if ((navmiddleware::settings::MAPVIEW_2D == currentMapView) ||
                  (navmiddleware::settings::MAPVIEW_3D == currentMapView))
            {
               leftSplitMapSettingsDisabled = IS_VISIBLE_FALSE;
            }

            currentTextStyleOption = getMapTextSize();
            currentMapOrientationOption = static_cast<unsigned int>((_navMiddleware.getMapSettings().getMapOrientation()) - 1);
            currentMapOrientationStr = MapOrientaionDropDownListLabel[currentMapOrientationOption];
            currentMapTextStyleStr = MapTextSizeListLabel[currentTextStyleOption];
            if ((navmiddleware::settings::MAPVIEW_3D == currentMapView) ||
                  (navmiddleware::settings::MAPVIEW_3D_SPLIT == currentMapView))
            {
               (*_mapOptionOthersSettingData).mMapOptionOthersSettingStatus = true;
               orientationtype[MAP_SETTING_HEADING_UP] = true;
            }
            else
            {
               (*_mapOptionOthersSettingData).mMapOptionOthersSettingStatus = false;
               orientationtype[currentMapOrientationOption] = true;
            }
            _mapOptionOthersSettingData.MarkAllItemsModified();
            _mapOptionOthersSettingData.SendUpdate(true);

            ETG_TRACE_USR4(("MapSettingsOthersListHandler::getListDataProvider(%d)", oMsg.GetListId()));

            ListDataProviderBuilder listBuilder(LIST_ID_MAP_SETTINGS_OTHERS);
            textStyleType[currentTextStyleOption] = true;

            isCheckboxEnabled[0] = getLongRange(_navMiddleware);
            isCheckboxEnabled[1] = getAutoZoom(_navMiddleware);

            listBuilder.AddItem(0, 0, DATA_CONTEXT_COMBOBOX_LIST_ITEMS_2)
            .AddData(MapOtherSettingsListItemText[0])
            .AddId(0, 1).AddData(MapOrientaionDropDownListLabel[0]).AddData(orientationtype[0])
            .AddId(0, 2).AddData(MapOrientaionDropDownListLabel[1]).AddData(orientationtype[1])
            .AddData(currentMapOrientationStr);
            listBuilder.AddItem(1, 0, DATA_CONTEXT_TEXT_LIST_ITEM)
            .AddData(MapOtherSettingsListItemText[1])
            .AddData(leftSplitMapSettingsDisabled);
            listBuilder.AddItem(2, 0, DATA_CONTEXT_COMBOBOX_LIST_ITEMS_3)
            .AddData(MapOtherSettingsListItemText[2])
            .AddId(2, 1).AddData(MapTextSizeListLabel[0]).AddData(textStyleType[0])
            .AddId(2, 2).AddData(MapTextSizeListLabel[1]).AddData(textStyleType[1])
            .AddId(2, 3).AddData(MapTextSizeListLabel[2]).AddData(textStyleType[2])
            .AddData(currentMapTextStyleStr);
            listBuilder.AddItem(3, 0, DATA_CONTEXT_TEXT_LIST_ITEM)
            .AddData(MapOtherSettingsListItemText[3])
            .AddData(true);
            listBuilder.AddItem(4, 0, DATA_CONTEXT_TEXT_LIST_ITEM)
            .AddData(MapOtherSettingsListItemText[4])
            .AddData(true);
            listBuilder.AddItem(5, 0, DATA_CONTEXT_TEXT_LIST_ITEM)
            .AddData(MapOtherSettingsListItemText[5])
            .AddData(true);
            listBuilder.AddItem(6, 0, DATA_CONTEXT_TEXT_LIST_ITEM)
            .AddData(MapOtherSettingsListItemText[6])
            .AddData(true);
            listBuilder.AddItem(7, 0, DATA_CONTEXT_ROUTE_SETTINGS_TOGGLE_OPTION)
            .AddData(MapOtherSettingsListItemText[7])
            .AddData(isCheckboxEnabled[0]);
            listBuilder.AddItem(11, 0, DATA_CONTEXT_ROUTE_SETTINGS_TOGGLE_OPTION)
            .AddData(MapOtherSettingsListItemText[11])
            .AddData(isCheckboxEnabled[1]);

            dataProvider = listBuilder.CreateDataProvider();
         }
         else
         {
            //do nothing
         }
         break;
      }
      case MAP_SETTINGS_LEFT_SPLIT_MAP:
      {
         dataProvider = _mapSettingsLeftSplitMapListHandler.getListDataProvider(oMsg);
         break;
      }

      case MAP_SETTINGS_DISPLAY_TEXT:
      {
         dataProvider = _mapSettingsTextListHandler.getListDataProvider(oMsg);
         break;
      }
      case MAP_SETTINGS_MAP_SCROLLING_INFO:
      {
         dataProvider = _mapSettingsScrollingInfoListHandler.getListDataProvider(oMsg);
         break;
      }
      case MAP_SETTINGS_TRACKING_DOTS:
      {
         dataProvider = _mapSettingsTrackingDotsListHandler.getListDataProvider(oMsg);
         break;
      }
      default:
      {
         break;
      }
   }

   return dataProvider;
}


bool MapSettingsOthersListHandler::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   bool isMsgConsumed = false;
   Candera::UInt32 listId = oMsg.GetListId();
   unsigned int rowIdx = (unsigned int)oMsg.GetHdl();
   const enReaction  reaction = oMsg.GetReaction();
   if (enRelease == reaction)
   {
      switch (_activeMapSettingsOtherListID)
      {
            ETG_TRACE_USR4(("MapSettingsOthersListHandler::onCourierMessage(const ButtonListItemUpdMsg): %d", oMsg.GetListId()));
         case MAP_SETTINGS_OTHERS_MAIN:
         {
            if (LIST_ID_MAP_SETTINGS_OTHERS == listId)
            {
               isMsgConsumed = handleButtonListItemUpdMsg(oMsg);
            }
            else
            {
               //do nothing
            }
            break;
         }
         case MAP_SETTINGS_LEFT_SPLIT_MAP:
         {
            isMsgConsumed = _mapSettingsLeftSplitMapListHandler.handleButtonListItemUpdMsg(oMsg);
            break;
         }
         case MAP_SETTINGS_DISPLAY_TEXT:
         {
            isMsgConsumed = _mapSettingsTextListHandler.handleButtonListItemUpdMsg(oMsg);
            break;
         }
         case MAP_SETTINGS_MAP_SCROLLING_INFO:
         {
            isMsgConsumed = _mapSettingsScrollingInfoListHandler.handleButtonListItemUpdMsg(oMsg);
            break;
         }
         case MAP_SETTINGS_TRACKING_DOTS:
         {
            isMsgConsumed = _mapSettingsTrackingDotsListHandler.handleButtonListItemUpdMsg(oMsg);
            break;
         }
         default:
         {
            break;
         }
      }
   }

   return isMsgConsumed;
}


bool MapSettingsOthersListHandler::handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg)
{
   Candera::UInt32 settingsOtherSceneTobeActivated = 0;
   navmiddleware::settings::MapSettings mapSettings = _navMiddleware.getMapSettings();
   bool updateScene = false;
   bool isListUpdate = false;
   bool isMsgConsumed = true;
   unsigned int rowIdx = (unsigned int)oMsg.GetHdl();

   switch (rowIdx)
   {
         ETG_TRACE_USR4(("MapSettingsOthersListHandler::handleButtonListItemUpdMsg(ButtonListItemUpdMsg), Row Id : %d", rowIdx));
      case MAP_SETTINGS_MAP_ORIENTATION:
      case MAP_SETTINGS_MAP_TEXT_SIZE:
      {
         processComboBox(oMsg.GetHdl(), oMsg.GetSubHdl());
         break;
      }
      case MAP_SETTINGS_LEFT_SPLIT_MAP:
      {
         settingsOtherSceneTobeActivated = MAP_SETTINGS_LEFT_SPLIT_MAP;
         updateScene = true;
         break;
      }
      case MAP_SETTINGS_MAP_COLOR:
      {
         settingsOtherSceneTobeActivated = MAP_SETTINGS_MAP_COLOR;
         updateScene = true;
         break;
      }
      case MAP_SETTINGS_DISPLAY_TEXT:
      {
         settingsOtherSceneTobeActivated = MAP_SETTINGS_DISPLAY_TEXT;
         updateScene = true;
         break;
      }
      case MAP_SETTINGS_MAP_SCROLLING_INFO:
      {
         settingsOtherSceneTobeActivated = MAP_SETTINGS_MAP_SCROLLING_INFO;
         updateScene = true;
         break;
      }
      case MAP_SETTINGS_TRACKING_DOTS:
      {
         settingsOtherSceneTobeActivated = MAP_SETTINGS_TRACKING_DOTS;
         updateScene = true;
         break;
      }
      case MAP_SETTINGS_LONG_RANGE: // LONG_RANGE
      {
         mapSettings.isMapLongRangeEnabled() ? mapSettings.setMapLongRange(false) : mapSettings.setMapLongRange(true);
         isListUpdate = true;
         break;
      }
      /*case MAP_SETTINGS_SHOW_ALL_FREEWAY_EXIT: // Show all Freeway Exits on Route
      {
         mapSettings.isShowAllFreewayExitsOnMapEnabled() ? mapSettings.setShowAllFreewayExitsOnMap(false) : mapSettings.setShowAllFreewayExitsOnMap(true);
         break;
      }
      case MAP_SETTINGS_SHOW_TURN_LIST: // Auto. Show Turn List on Freeway
      {
         mapSettings.isAutoShowTurnListOnFreewayEnabled() ? mapSettings.setAutoShowTurnListOnFreeway(false) : mapSettings.setAutoShowTurnListOnFreeway(true);
         break;
      }
      case MAP_SETTINGS_NORTH_UP_WHEN_ZOOMED: // North Up when Zoomed Out
      {
         mapSettings.isNorthUpZoomOutEnabled() ? mapSettings.setNorthUpZoomOut(false) : mapSettings.setNorthUpZoomOut(true);
         break;
      }*/
      case MAP_SETTINGS_AUTO_ZOOM:// Auto Zoom
      {
         mapSettings.isAutoZoomEnabled() ? mapSettings.setAutoZoomEnabled(false) : mapSettings.setAutoZoomEnabled(true);
         isListUpdate = true;
         break;
      }
      default:
      {
         isMsgConsumed = false;
         break;
      }
   }

   if (true == updateScene)
   {
      updateSceneTitle(rowIdx);
      POST_MSG((COURIER_MESSAGE_NEW(MapSettingsOthersListUpdateMsg)(settingsOtherSceneTobeActivated)));
   }
   else if (isListUpdate == true)
   {
      _navMiddleware.updateMapSettings(mapSettings);
      ListRegistry::s_getInstance().updateList(LIST_ID_MAP_SETTINGS_OTHERS);
   }

   return isMsgConsumed;
}


void MapSettingsOthersListHandler::processComboBox(Courier::UInt32 hdl, Courier::UInt32 subHdl)
{
   ETG_TRACE_USR4(("MapSettingsOthersListHandler::processComboBox: Hdl: %d, SubHdl: %d", hdl, subHdl));
   subHdl = subHdl - 1;  // subtracting 1 as the dropdown item values start with the index of 0
   switch (hdl)
   {
      case MAP_SETTINGS_MAP_ORIENTATION:
      {
         changeMapOrientationSettings(subHdl);
         break;
      }
      case MAP_SETTINGS_MAP_TEXT_SIZE:
      {
         changeMapTextStyle(subHdl);
         break;
      }
      default:
         break;
   }
   ::hmibase::widget::combobox::ComboBoxReqMsg* cbToggleMsg = COURIER_MESSAGE_NEW(::hmibase::widget::combobox::ComboBoxReqMsg)(0, ::hmibase::widget::combobox::enComboBoxAction::Close); //ComboBoxAction enComboBoxAction::Enum::ComboBoxClose:
   if (cbToggleMsg != NULL)
   {
      cbToggleMsg->Post();
   }

   ListRegistry::s_getInstance().updateList(LIST_ID_MAP_SETTINGS_OTHERS);
}


unsigned int MapSettingsOthersListHandler::getMapTextSize()
{
   unsigned int _mapTextSize = _navMiddleware.getMapSettings().getMapTextSize();
   unsigned int returnValue = 0;

   switch (_mapTextSize)
   {
      case navmiddleware::settings::MAPTEXTSIZE_SMALL:
      {
         returnValue = MAP_TEXT_STYLE_SMALL;
      }
      break;
      case navmiddleware::settings::MAPTEXTSIZE_MEDIUM:
      {
         returnValue = MAP_TEXT_STYLE_MEDIUM;
      }
      break;
      case navmiddleware::settings::MAPTEXTSIZE_LARGE:
      {
         returnValue = MAP_TEXT_STYLE_LARGE;
      }
      break;
      default:
         break;
   }
   return returnValue;
}


bool MapSettingsOthersListHandler::onCourierMessage(const ApplyMapViewSettingsReqMsg& oMsg)
{
   COURIER_UNUSED(oMsg);
   _navMiddleware.applySettings();
   return true;
}


bool MapSettingsOthersListHandler::onCourierMessage(const ActivateOthersMapSettingListReqMsg& oMsg)
{
   _activeMapSettingsOtherListID = oMsg.GetMapSettingsOthersListID();

   if (MAP_SETTINGS_OTHERS_MAIN == _activeMapSettingsOtherListID)
   {
      _currentHierarchyLevel = LEVEL_ONE;
   }
   else
   {
      _currentHierarchyLevel = LEVEL_TWO;
   }
   POST_MSG((COURIER_MESSAGE_NEW(SetBackButtonLevelReqMsg)(_currentHierarchyLevel)));
   //changeBackButtonBG();
   //(*_mapSettingOtherListIDData).mListID = LIST_ID_MAP_SETTINGS_OTHERS;
   //_mapSettingOtherListIDData.MarkAllItemsModified();
   //_mapSettingOtherListIDData.SendUpdate(true);
   ListRegistry::s_getInstance().updateList(LIST_ID_MAP_SETTINGS_OTHERS);
   return false;
}


bool MapSettingsOthersListHandler::onCourierMessage(const DeleteTrackingPointReqMsg& oMsg)
{
   COURIER_UNUSED(oMsg);
   _navMiddleware.deleteAllTrackingDots();
   navmiddleware::settings::MapTrackingDotsSettings mapTrackingDotSettings = _navMiddleware.getMapTrackingDotsSettings();
   mapTrackingDotSettings.setMapTrackingDotDistance(navmiddleware::settings::MapTrackingDotsSettings::MAP_TRACKING_DOT_DISTANCE_TWO_HUNDRED_METER);
   _navMiddleware.updateMapTrackingDotsSettings(mapTrackingDotSettings);
   _navMiddleware.applySettings();
   ListRegistry::s_getInstance().updateList(LIST_ID_MAP_SETTINGS_OTHERS);

   POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Hide, Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_MultiLine_TwoButton"))));

   return true;
}


bool MapSettingsOthersListHandler::onCourierMessage(const LeftMapViewSetMapScaleReqMsg& oMsg)
{
   COURIER_UNUSED(oMsg);
   ETG_TRACE_USR4(("MapSettingsOthersListHandler::onCourierMessage(LeftMapViewSetMapScaleReqMsg)"));
   const navmiddleware::MapCameraInfos& mapCameraInfos = _navMiddleware.getMapCameraInfos();
   ::navmiddleware::settings::MapSettings mapLeftMapZoomsettings = _navMiddleware.getMapSettings();
   mapLeftMapZoomsettings.setMapSecondaryViewMapScale(mapCameraInfos.getMapScale());
   _navMiddleware.updateMapSettings(mapLeftMapZoomsettings);
   return true;
}


bool MapSettingsOthersListHandler::changeMapOrientationSettings(Candera::UInt32 selectedRowId)
{
   ETG_TRACE_USR4(("MapSettingsOthersListHandler::changeMapOrientationSettings(), Row Id : %d", selectedRowId));
   navmiddleware::settings::MapOrientation mapOrientation = navmiddleware::settings::MAP_ORIENTATION_HEAD_UP;
   MapSettingsListItem& mapOrientaionSettingListElement = _mapSettingsList.at(MAP_SETTINGS_MAP_ORIENTATION);
   bool isListUpdated = false;

   switch (selectedRowId)
   {
      case MAP_SETTING_NORTH_UP:
      {
         mapOrientation = navmiddleware::settings::MAP_ORIENTATION_NORTH_UP;
         isListUpdated = true;
         break;
      }
      case MAP_SETTING_HEADING_UP:
      {
         mapOrientation = navmiddleware::settings::MAP_ORIENTATION_HEAD_UP;
         isListUpdated = true;
         break;
      }
      default:
      {
         break;
      }
   }

   if (true == isListUpdated)
   {
      navmiddleware::settings::MapSettings mapSettings = _navMiddleware.getMapSettings();
      mapSettings.setMapOrientation(mapOrientation);
      _navMiddleware.updateMapSettings(mapSettings);
   }

   return isListUpdated;
}


bool MapSettingsOthersListHandler::changeMapTextStyle(Candera::UInt32 selectedRowId)
{
   ETG_TRACE_USR4(("MapSettingsOthersListHandler::changeMapTextStyle(), Row Id : %d", selectedRowId));
   navmiddleware::settings::MapSettings mapSettings = _navMiddleware.getMapSettings();
   navmiddleware::settings::MapTextSize mapTextSize = navmiddleware::settings::MAPTEXTSIZE_MEDIUM;
   MapSettingsListItem& mapTextStyleListElement = _mapSettingsList.at(MAP_SETTINGS_MAP_TEXT_SIZE);
   bool isListUpdated = false;

   switch (selectedRowId)
   {
      case MAP_TEXT_STYLE_SMALL:
      {
         mapTextSize = navmiddleware::settings::MAPTEXTSIZE_SMALL;
         isListUpdated = true;
         break;
      }
      case MAP_TEXT_STYLE_MEDIUM:
      {
         mapTextSize = navmiddleware::settings::MAPTEXTSIZE_MEDIUM;
         isListUpdated = true;
         break;
      }
      case MAP_TEXT_STYLE_LARGE:
      {
         mapTextSize = navmiddleware::settings::MAPTEXTSIZE_LARGE;
         isListUpdated = true;
         break;
      }
      default:
      {
         mapTextSize = navmiddleware::settings::MAPTEXTSIZE_SMALL;
         break;
      }
   }
   if (true == isListUpdated)
   {
      mapSettings.setMapTextSize(mapTextSize);
      _navMiddleware.updateMapSettings(mapSettings);
   }

   return isListUpdated;
}


//void MapSettingsOthersListHandler::changeBackButtonBG()
//{
//   switch (_currentHierarchyLevel)
//   {
//      case LEVEL_ONE:
//      {
//         (*_mapSettingsOthersBackButtonLevel).mIsButtonBackThreeLevelEnabled = false;
//         break;
//      }
//      case LEVEL_TWO:
//      {
//         (*_mapSettingsOthersBackButtonLevel).mIsButtonBackThreeLevelEnabled = true;
//         break;
//      }
//   }
//   _mapSettingsOthersBackButtonLevel.MarkItemModified(ItemKey::MapSettingsOthersBackButtonLevel::IsButtonBackThreeLevelEnabledItem);
//   _mapSettingsOthersBackButtonLevel.SendUpdate();
//}


void MapSettingsOthersListHandler::updateSceneTitle(Candera::UInt32 selectedRow)
{
   (*_mapSettingsOthersTitle).mMapOtherSettingsTitleValue = LANGUAGE_STRING(TextId_0x1404, "More options");
   if (selectedRow < _mapSettingsList.size())
   {
      (*_mapSettingsOthersTitle).mMapOtherSettingsTitleValue = _mapSettingsList.at(selectedRow)._text;
   }
   _mapSettingsOthersTitle.MarkItemModified(ItemKey::MapSettingsOthersTitle::MapOtherSettingsTitleValueItem);
   _mapSettingsOthersTitle.SendUpdate();
}


void MapSettingsOthersListHandler::onPropertyMapPresentationModeChanged()
{
   navmiddleware::MapRepresentationInfo mapRepresentaionInfo = _navMiddleware.getMapRepresentationInfo();

   navmiddleware::MapViewId mapViewId = mapRepresentaionInfo.getMapViewId();
   if (navmiddleware::MAP_VIEW_ID__PRIMARY == mapViewId)
   {
      navmiddleware::settings::MapOrientation mapOrientation = mapRepresentaionInfo.getMapRepresentation().m_mapOrientation;
      ETG_TRACE_USR4(("MapSettingsOthersListHandler::onPropertyMapRepresentaionModeChanged(), Map view id : %d, Map orientation : %d", mapViewId, mapOrientation));

      MapSettingsListItem& mapOrientaionSettingListElement = _mapSettingsList.at(MAP_SETTINGS_MAP_ORIENTATION);
   }
   else if (navmiddleware::MAP_VIEW_ID__SECONDARY == mapViewId)
   {
      _mapSettingsLeftSplitMapListHandler.onPropertyMapPresentationModeChanged();
   }
   else
   {
   }
}


#endif // HALL_TO_MDW_COM
