/**************************************************************************************
* @file         : MapSettingsListHandler.h
* @author       : ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef MAP_SETTINGS_LIST_HANDLER_H
#define MAP_SETTINGS_LIST_HANDLER_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"
#include "NaviSettingsUtil.h"

#ifdef HALL_TO_MDW_COM

class MapSettingsListHandler : public NavMiddlewarePropertyUpdateConsumer, public ListImplementation
{
   public:
      MapSettingsListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~MapSettingsListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_PRESENTATION_MODE_CHANGED, onPropertyMapPresentationModeChanged);
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(ApplyMapViewSettingsReqMsg)
      ON_COURIER_MESSAGE(UpdateMapSettingsListReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      bool onCourierMessage(const ApplyMapViewSettingsReqMsg& oMsg);
      bool onCourierMessage(const UpdateMapSettingsListReqMsg& oMsg);

   private:
      unsigned int _listId;
      unsigned int _startIndex;
      unsigned int _windowElementSize;

      enum MapSettingsListItemValue
      {
         MAP_SETTINGS_MAP_VIEW,
         MAP_SETTINGS_GUIDANCE_VIEW,
         MAP_SETTINGS_SHOW_POI_ON_MAP,
         MAP_SETTINGS_MORE_OPTION
      };

      enMapViewSettingOptions _mapViewSettingOption;
      enGuidanceViewInfoSettingOptions _guidanceViewSettingOption;

      Candera::String _currentMapView;
      Candera::String _currentGuidanceView;

      bool _mapView[MAX_SIZE_MAPSETTINGS_LIST];
      bool _guidanceView[MAX_SIZE_GUIDANCE_VIEW_OPTION];

      typedef ListItemBase<MapSettingsListItemValue> MapSettingsListItem;
      std::vector<MapSettingsListItem> _mapSettingsList;

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      void changeDualMapViewSettings(Candera::UInt32 selectedRowId);
      void changeLeftSideInfoSettings(Candera::UInt32 selectedRowId);
      void onPropertyMapPresentationModeChanged();
      void processComboBox(Courier::UInt32 hdl, Courier::UInt32 subHdl);
      void resetSelectedOption();
      FEATSTD_MAKE_CLASS_UNCOPYABLE(MapSettingsListHandler);
      InfoStore& _infoStore;

      DataBindingItem<StreamedMapSettingDataBindingSource> _streamedMapSettingData;
};


#endif // HALL_TO_MDW_COM
#endif // MAP_SETTINGS_LIST_HANDLER_H
