/**************************************************************************************
* @file         : MapSettingsLeftSplitMapListHandler.h
* @author       : ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef MAP_SETTINGS_LEFT_SPLI_MAP_LIST_HANDLER_H
#define MAP_SETTINGS_LEFT_SPLI_MAP_LIST_HANDLER_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"


#ifdef HALL_TO_MDW_COM

class MapSettingsLeftSplitMapListHandler : public HMIModelBase
{
   public:
      MapSettingsLeftSplitMapListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~MapSettingsLeftSplitMapListHandler();

      virtual void initialize();
      virtual void deinitialize();

      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      bool onCourierMessage(const ActivateOthersMapSettingListReqMsg& oMsg);
      bool onCourierMessage(const ApplyMapViewSettingsReqMsg& oMsg);
      void onPropertyMapPresentationModeChanged();
      bool handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg);
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);

   private:
      unsigned int _listId;

      enum MapSettingsListItemValue
      {
         LEFT_SPLIT_MAP_SETTINGS_LIST_ITEM_MAP_ORIENTATION,
         LEFT_SPLIT_MAP_SETTINGS_LIST_ITEM_MAP_SCALE,
         LEFT_SPLIT_MAP_SETTINGS_LIST_ITEM_LONG_RANGE
      };

      Candera::UInt32 _activeMapSettingsOtherListID;
      typedef ListItemBase<MapSettingsListItemValue> MapSettingsListItem;
      std::vector<MapSettingsListItem> _leftSplitMapSettingsList;
      DataBindingItem<MapSettingOthersListIDDataBindingSource>_mapSettingOtherListIDData;

      tSharedPtrDataProvider getListDataProviderMainList();
      tSharedPtrDataProvider configureDropdownList(::Courier::UInt32 currentListID);
      void changeMapOrientationSettings(Candera::UInt32 selectedRowId);
      void processComboBox(Courier::UInt32 hdl, Courier::UInt32 subHdl);
      FEATSTD_MAKE_CLASS_UNCOPYABLE(MapSettingsLeftSplitMapListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // MAP_SETTINGS_LEFT_SPLI_MAP_LIST_HANDLER_H
