/**************************************************************************************
* @file         : DestinationLatLongSpellerHandler.cpp
* @author       : ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include  <vector>
#include "MapSettingsLeftSplitMapListHandler.h"
#include "MapSettingsOthersUtil.h"
#include "NaviSettingsUtil.h"


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/MapSettingsLeftSplitMapListHandler.cpp.trc.h"
#endif

#ifdef  HALL_TO_MDW_COM


static const char* const DATA_CONTEXT_COMBOBOX_LIST_ITEMS_2 = "ComboBox_ListItem2";
static const char* const DATA_CONTEXT_ROUTE_SETTINGS_TOGGLE_OPTION = "Layer_Checkbox";
static const char* const DATA_CONTEXT_TEXT_LIST_ITEM = "Layer_ListButton";


MapSettingsLeftSplitMapListHandler::MapSettingsLeftSplitMapListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore)
   : HMIModelBase(navMiddleware, infoStore)
   , _activeMapSettingsOtherListID(0)
{
   // configuring static list item
   _listId = LIST_ID_MAP_SETTINGS_OTHERS;
}


MapSettingsLeftSplitMapListHandler::~MapSettingsLeftSplitMapListHandler()
{
}


void MapSettingsLeftSplitMapListHandler::initialize()
{
   unsigned int currentMapOrientationOption = 0;
   Candera::String leftMapOrientationStr;
   if (_navMiddleware.getMapSettings().getMapSecondaryViewOrientation())
   {
      currentMapOrientationOption = static_cast<unsigned int>((_navMiddleware.getMapSettings().getMapSecondaryViewOrientation()) - 1);
   }
   leftMapOrientationStr = MapOrientaionDropDownListLabel[currentMapOrientationOption];

   _leftSplitMapSettingsList.reserve(MAX_LIST_LEFT_SPLIT_SIZE);
   _leftSplitMapSettingsList.push_back(MapSettingsListItem(LANGUAGE_STRING(TextId_0x13EE, "Map orientation"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_DROPDOWN, LEFT_SPLIT_MAP_SETTINGS_LIST_ITEM_MAP_ORIENTATION, leftMapOrientationStr, LIST_ID_DROPDOWN_MAP_ORIENTATION));
   _leftSplitMapSettingsList.push_back(MapSettingsListItem(LANGUAGE_STRING(TextId_0x13F9, "Map scale"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_BUTTON, LEFT_SPLIT_MAP_SETTINGS_LIST_ITEM_MAP_SCALE));
   _leftSplitMapSettingsList.push_back(MapSettingsListItem(LANGUAGE_STRING(TextId_0x13F1, "Long range"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, LEFT_SPLIT_MAP_SETTINGS_LIST_ITEM_LONG_RANGE, getMapLeftViewLongeRange));
}


void MapSettingsLeftSplitMapListHandler::deinitialize()
{
}


tSharedPtrDataProvider MapSettingsLeftSplitMapListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   _listId = oMsg.GetListId();
   tSharedPtrDataProvider dataProvider;
   if (LIST_ID_MAP_SETTINGS_OTHERS == _listId)
   {
      unsigned int currentMapOrientationOption = 0;
      Candera::String leftMapOrientationStr = "";
      bool orientationType[MAX_SIZE_MAPORIENTAION_DROPDOWN] = {false};
      bool isCheckboxEnabled = false;
      if (_navMiddleware.getMapSettings().getMapSecondaryViewOrientation())
      {
         currentMapOrientationOption = static_cast<unsigned int>((_navMiddleware.getMapSettings().getMapSecondaryViewOrientation()) - 1);
      }
      leftMapOrientationStr = MapOrientaionDropDownListLabel[currentMapOrientationOption];
      isCheckboxEnabled = getMapLeftViewLongeRange(_navMiddleware);
      orientationType[currentMapOrientationOption] = true;
      ListDataProviderBuilder listBuilder(LIST_ID_MAP_SETTINGS_OTHERS);

      listBuilder.AddItem(0, 0, DATA_CONTEXT_COMBOBOX_LIST_ITEMS_2)
      .AddData(LeftSplitMapSettingsListItemText[0])
      .AddId(0, 1).AddData(MapOrientaionDropDownListLabel[0]).AddData(orientationType[0])
      .AddId(0, 2).AddData(MapOrientaionDropDownListLabel[1]).AddData(orientationType[1])
      .AddData(leftMapOrientationStr);
      listBuilder.AddItem(1, 0, DATA_CONTEXT_TEXT_LIST_ITEM)
      .AddData(LeftSplitMapSettingsListItemText[1]);
      listBuilder.AddItem(2, 0, DATA_CONTEXT_ROUTE_SETTINGS_TOGGLE_OPTION)
      .AddData(LeftSplitMapSettingsListItemText[2])
      .AddData(isCheckboxEnabled);

      dataProvider = listBuilder.CreateDataProvider();
   }

   return dataProvider;
}


bool MapSettingsLeftSplitMapListHandler::handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg)
{
   bool isMsgConsumed = false;
   Candera::UInt32 listId = oMsg.GetListId();
   unsigned int rowIdx = (unsigned int)oMsg.GetHdl();
   const enReaction  reaction = oMsg.GetReaction();

   if (enRelease == reaction)
   {
      if (LIST_ID_MAP_SETTINGS_OTHERS == listId)
      {
         ETG_TRACE_USR4(("MapSettingsLeftSplitMapListHandler::onCourierMessage(ButtonListItemUpdMsg), List Id : %d, Row Id : %d", listId, rowIdx));
         switch (rowIdx)
         {
            case LEFT_SPLIT_MAP_SETTINGS_LIST_ITEM_MAP_ORIENTATION:
            {
               processComboBox(rowIdx, oMsg.GetSubHdl());
               isMsgConsumed = true;
               break;
            }
            case LEFT_SPLIT_MAP_SETTINGS_LIST_ITEM_MAP_SCALE:
            {
               isMsgConsumed = true;
               //Activate New Scene
               break;
            }
            case LEFT_SPLIT_MAP_SETTINGS_LIST_ITEM_LONG_RANGE:
            {
               //Toggle The Setting in Middleware
               navmiddleware::settings::MapSettings mapLeftViewMapSettings = _navMiddleware.getMapSettings();
               mapLeftViewMapSettings.isMapSecondaryViewLongRangeEnabled() ? mapLeftViewMapSettings.setMapSecondaryViewLongRange(false) : mapLeftViewMapSettings.setMapSecondaryViewLongRange(true);
               _navMiddleware.updateMapSettings(mapLeftViewMapSettings);
               ListRegistry::s_getInstance().updateList(LIST_ID_MAP_SETTINGS_OTHERS);
               isMsgConsumed = true;
               break;
            }
            default:
            {
               break;
            }
         }
      }
      else
      {
         // do nothing
      }
   }

   return isMsgConsumed;
}


void MapSettingsLeftSplitMapListHandler::processComboBox(Courier::UInt32 hdl, Courier::UInt32 subHdl)
{
   ETG_TRACE_USR4(("MapSettingsLeftSplitMapListHandler::processComboBox: Hdl: %d, SubHdl: %d", hdl, subHdl));
   subHdl = subHdl - 1;  //subtracting 1 as the dropdown item values start with the index of 0

   changeMapOrientationSettings(subHdl);
   ::hmibase::widget::combobox::ComboBoxReqMsg* cbToggleMsg = COURIER_MESSAGE_NEW(::hmibase::widget::combobox::ComboBoxReqMsg)(0, ::hmibase::widget::combobox::enComboBoxAction::Close); //ComboBoxAction enComboBoxAction::Enum::ComboBoxClose:
   if (cbToggleMsg != NULL)
   {
      cbToggleMsg->Post();
   }
   ListRegistry::s_getInstance().updateList(LIST_ID_MAP_SETTINGS_OTHERS);
}


void MapSettingsLeftSplitMapListHandler::changeMapOrientationSettings(Candera::UInt32 selectedRowId)
{
   ETG_TRACE_USR4(("MapSettingsLeftSplitMapListHandler::changeMapOrientationSettings(), Row Id : %d", selectedRowId));
   navmiddleware::settings::MapOrientation mapOrientation = navmiddleware::settings::MAP_ORIENTATION_HEAD_UP;
   MapSettingsListItem& mapOrientaionSettingListElement = _leftSplitMapSettingsList.at(LEFT_SPLIT_MAP_SETTINGS_LIST_ITEM_MAP_ORIENTATION);
   bool isListUpdated = false;
   switch (selectedRowId)
   {
      case MAP_SETTING_NORTH_UP:
      {
         mapOrientation = navmiddleware::settings::MAP_ORIENTATION_NORTH_UP;
         isListUpdated = true;
         break;
      }
      case MAP_SETTING_HEADING_UP:
      {
         mapOrientation = navmiddleware::settings::MAP_ORIENTATION_HEAD_UP;
         isListUpdated = true;
         break;
      }
      default:
      {
         break;
      }
   }

   if (isListUpdated)
   {
      navmiddleware::settings::MapSettings mapSettings = _navMiddleware.getMapSettings();
      mapSettings.setMapSecondaryViewOrientation(mapOrientation);
      _navMiddleware.updateMapSettings(mapSettings);
   }
}


void MapSettingsLeftSplitMapListHandler::onPropertyMapPresentationModeChanged()
{
   ETG_TRACE_USR4(("MapSettingsLeftSplitMapListHandler::onPropertyMapPresentationModeChanged()"));

   MapSettingsListItem& mapOrientaionSettingListElement = _leftSplitMapSettingsList.at(LEFT_SPLIT_MAP_SETTINGS_LIST_ITEM_MAP_ORIENTATION);
   mapOrientaionSettingListElement._dropDownText = getMapOrientation(_navMiddleware, true);
}


#endif // HALL_TO_MDW_COM
