/**************************************************************************************
* @file         : MapColorStyleListHandler.h
* @author       : ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef MAP_COLOR_STYLE_LIST_HANDLER
#define MAP_COLOR_STYLE_LIST_HANDLER

#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"

#if defined(HALL_TO_MDW_COM)

class MapColorStyleListHandler : public NavMiddlewarePropertyUpdateConsumer, public ListImplementation
{
   public:
      MapColorStyleListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~MapColorStyleListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_END()

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);

   private:
      enum MapColorStyleListItemValue
      {
         MAP_COLOR_STYLE_LIST_ITEM_SPEED_COLOR_1,
         MAP_COLOR_STYLE_LIST_ITEM_SPEED_COLOR_2,
         MAP_COLOR_STYLE_LIST_ITEM_SPEED_COLOR_3,
         MAP_COLOR_STYLE_LIST_ITEM_SPEED_COLOR_4
      };
      typedef ListItemBase<MapColorStyleListItemValue> MapColorStyleListItem;
      std::vector<MapColorStyleListItem> _mapColorStyleList;
      FEATSTD_MAKE_CLASS_UNCOPYABLE(MapColorStyleListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // MAP_COLOR_STYLE_LIST_HANDLER
