/**************************************************************************************
* @file         : HMIModelSettings.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef HMI_MODEL_SETTINGS_H
#define HMI_MODEL_SETTINGS_H

#include "Common/Util/HMIModelIncludes.h"
#include "NavigationSettingsListHandler.h"
#include "RoutePreferenceListHandler.h"
#include "DetailedRoutePreferenceListHandler.h"
#include "MapSettingsListHandler.h"
#include "MapSettingsShowPOIListHandler.h"
#include "MapSettingsOthersListHandler.h"
#include "MapSettingsLeftSplitMapListHandler.h"
#include "MapColorStyleListHandler.h"
#include "VehicleParameterListHandler.h"
#include "GuidanceSettingsHandler.h"
#include "TrafficIconsSettingsListHandler.h"
#include "StreamedMapSettingsListHandler.h"
#include "StreamedMapSubOptionListHandler.h"
#include "PremiumTrafficListHandler.h"
#include "SpeedLimitSettingsListHandler.h"
#include "UserPOISettingsListHandler.h"

#ifdef HALL_TO_MDW_COM

class HMIModelSettings : public HMIModelBase
{
   public:
      HMIModelSettings(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~HMIModelSettings();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_DISTANCE_UNIT_SYSTEM_CHANGED, onPropertyUpdateDistanceUnitSystemChanged);
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_LANGUAGE_CHANGED, onPropertyUpdateLanguageChanged);
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_COUNTRYCODE_CHANGED, onPropertyUpdateCountryCodeChanged);
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_LIGHT_MODE_CHANGED, onPropertyUpdateLightModeChanged);
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_SPEED_LIMIT_STATUS_CHANGED, onPropertySpeedLimitStatusChanged);
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_DATE_FORMAT_CHANGED, onPropertyDateFormatChanged);
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_TIME_FORMAT_CHANGED, onPropertyTimeFormatChanged);
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_LOCAL_TIME_OFFSET_INFO_CHANGED, onPropertyUpdateLocalTimeOffsetInfoChanged);
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_RESET_FACTORY_CHANGED, onPropertyUpdateResetFactoryChanged);
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_RESET_FACTORY_PRODUCTION_CHANGED, onPropertyUpdateResetFactoryProductionChanged);
      PROPERTY_UPDATE_INFOSTORE_END()

      //! Property update register
      bool onPropertyUpdateDistanceUnitSystemChanged();
      bool onPropertyUpdateLanguageChanged() const;
      bool onPropertyUpdateCountryCodeChanged();
      bool onPropertyUpdateLightModeChanged();
      bool onPropertySpeedLimitStatusChanged() const;
      bool onPropertyDateFormatChanged() const;
      bool onPropertyTimeFormatChanged() const;
      bool onPropertyUpdateLocalTimeOffsetInfoChanged() const;
      bool onPropertyUpdateResetFactoryChanged();
      bool onPropertyUpdateResetFactoryProductionChanged();

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_REF(_navigationSettingsListHandler)
      COURIER_MSG_DELEGATE_TO_REF(_routePreferenceListHandler)
      COURIER_MSG_DELEGATE_TO_REF(_detailedRoutePreferenceListHandler)
      COURIER_MSG_DELEGATE_TO_REF(_mapSettingsListHandler)
      COURIER_MSG_DELEGATE_TO_REF(_mapSettingsShowPOIListHandler)
      COURIER_MSG_DELEGATE_TO_REF(_mapSettingsOtherListHandler)
      COURIER_MSG_DELEGATE_TO_REF(_mapColorStyelListHandler)
      COURIER_MSG_DELEGATE_TO_REF(_vehicleParameterListHandler)
      COURIER_MSG_DELEGATE_TO_REF(_guidanceSettingsHandler)
      COURIER_MSG_DELEGATE_TO_REF(_trafficIconsSettingsListHandler)
      COURIER_MSG_DELEGATE_TO_REF(_streamedMapSubOptionListHandler)
      COURIER_MSG_DELEGATE_TO_REF(_streamedMapSettingListHandler)
      COURIER_MSG_DELEGATE_TO_REF(_premiumTrafficListHandler)
      COURIER_MSG_DELEGATE_TO_REF(_speedLimitSettingListHandler)
      COURIER_MSG_DELEGATE_TO_REF(_userPOISettingsListHandler)
      COURIER_MSG_MAP_DELEGATE_END()

   private:
      NavigationSettingsListHandler       _navigationSettingsListHandler;
      RoutePreferenceListHandler          _routePreferenceListHandler;
      DetailedRoutePreferenceListHandler  _detailedRoutePreferenceListHandler;
      MapSettingsListHandler              _mapSettingsListHandler;
      MapSettingsShowPOIListHandler       _mapSettingsShowPOIListHandler;
      MapSettingsOthersListHandler        _mapSettingsOtherListHandler;
      MapColorStyleListHandler            _mapColorStyelListHandler;
      VehicleParameterListHandler         _vehicleParameterListHandler;
      GuidanceSettingsHandler             _guidanceSettingsHandler;
      TrafficIconsSettingsListHandler     _trafficIconsSettingsListHandler;
      StreamedMapSettingsListHandler      _streamedMapSettingListHandler;
      StreamedMapSubOptionListHandler     _streamedMapSubOptionListHandler;
      PremiumTrafficListHandler           _premiumTrafficListHandler;
      SpeedLimitSettingsListHandler       _speedLimitSettingListHandler;
      UserPOISettingsListHandler          _userPOISettingsListHandler;
      DataBindingItem<NaviSpellerInfoDataBindingSource> _naviSpellerInfo;
      DataBindingItem<SpellerPagesDataBindingSource> _spellerPageInfoData;
      DataBindingItem<MapModeDataBindingSource> _mapModeData;

      bool onPropertyUpdateLanguageChanged();
      FEATSTD_MAKE_CLASS_UNCOPYABLE(HMIModelSettings);
};


#endif // HALL_TO_MDW_COM
#endif // HMI_MODEL_SETTINGS_H
