/**************************************************************************************
* @file         : HMIModelPosition.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include "HMIModelPosition.h"
#include "PositionInfoDataUtils.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/HMIModelPosition.cpp.trc.h"
#endif

#if defined (HALL_TO_MDW_COM)

static const int MAX_HEADING_INDEX = 31;
static const int MIN_HEADING_INDEX = 0;

using namespace navmiddleware;

HMIModelPosition::HMIModelPosition(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore)
   : HMIModelBase(navMiddleware, infoStore)
{
}


HMIModelPosition::~HMIModelPosition()
{
}


void HMIModelPosition::initialize()
{
   _navMiddleware.registerPositionPropertyUpdateCallback(*this);
}


void HMIModelPosition::deinitialize()
{
   _navMiddleware.unregisterPositionPropertyUpdateCallback(*this);
}


bool HMIModelPosition::onPropertyUpdateGPSSensorStatusChanged()
{
   ETG_TRACE_USR4(("HMIModelPosition::onPropertyUpdateGPSSensorStatusChanged() %d ", _navMiddleware.getGnssDataInfo().getSpeed()));
   navmiddleware::DateFormat dateFormat = _infoStore.getDateFormat();
   bool isDayModeActive = ((LIGHT_MODE_DAY_PERMANENT == _infoStore.getLightMode()) || (LIGHT_MODE_DAY_AUTO == _infoStore.getLightMode())) ? true : false;
   setGpsSensorInfos(_navMiddleware.getGnssDataInfo(), dateFormat);
   setGpsSensorlatlongInfos(_navMiddleware.getGnssDataInfo(), isDayModeActive, _navMiddleware.isDemoModeActive());
   return sendGpsInfoData();
}


bool HMIModelPosition::onCourierMessage(const EnableWhereAmIReqMsg& oMsg)
{
   COURIER_UNUSED(oMsg);
   ETG_TRACE_USR1(("HMIModelPosition::onCourierMessage(EnableWhereAmIReqMsg)"));

   _navMiddleware.enableWhereAmIInfo();
   return true;
}


bool HMIModelPosition::onCourierMessage(const DisableWhereAmIReqMsg& oMsg)
{
   COURIER_UNUSED(oMsg);
   ETG_TRACE_USR1(("HMIModelPosition::onCourierMessage(DisableWhereAmIReqMsg)"));

   _navMiddleware.disableWhereAmIInfo();
   return true;
}


bool HMIModelPosition::onPropertyUpdateWhereAmIStatusChanged()
{
   ETG_TRACE_USR4(("HMIModelPosition::onPropertyUpdateWhereAmIStatusChanged()"));
   setWhereAmIScreenDataWhereAmIStatusInfos(_navMiddleware.getWhereAmIInfo());

   return sendWhereAmIScreenData();
}


void HMIModelPosition::onPropertyUpdateSimulationModeChanged()
{
   ETG_TRACE_USR4(("HMIModelPosition::onPropertyUpdateSimulationModeChanged()"));

   bool isDayModeActive = ((LIGHT_MODE_DAY_PERMANENT == _infoStore.getLightMode()) || (LIGHT_MODE_DAY_AUTO == _infoStore.getLightMode())) ? true : false;
   setSatelliteIconVisibility(_navMiddleware.getGnssDataInfo(), isDayModeActive, _navMiddleware.isDemoModeActive());
}


#endif // HALL_TO_MDW_COM
