/**************************************************************************************
* @file         : GuidanceSettingsHandler.h
* @author       : ECG-Ramesh Kesavan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef GUIDANCE_SETTINGS_HANDLER_H
#define GUIDANCE_SETTINGS_HANDLER_H

#include "AppHmi_NavigationStateMachine.h"
#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"

#ifdef HALL_TO_MDW_COM

class GuidanceSettingsHandler : public NavMiddlewarePropertyUpdateConsumer, public InfoStorePropertyUpdateConsumer, public ListImplementation
{
   public:
      GuidanceSettingsHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~GuidanceSettingsHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from Infostore
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_GUIDANCE_VOLUME_CHANGED, onPropertyUpdateGuidanceVolumeChanged);
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_HARD_RESTRICTION_STATUS_CHANGED, onPropertyUpdateHardRestrictionStatusChanged);
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_SETTINGS_CHANGED, onPropertyUpdateGuidanceSettingsChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      //ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(ApplyGuidanceSettingsReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      bool onPropertyUpdateGuidanceVolumeChanged();
      bool onPropertyUpdateGuidanceSettingsChanged();
      bool onPropertyUpdateHardRestrictionStatusChanged();

      //bool onCourierMessage(const ButtonReactionMsg &oMsg);
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      bool onCourierMessage(const ApplyGuidanceSettingsReqMsg& oMsg);

   private:

      enum GuidanceSettingListItemValue
      {
         SETTING_TRAFFIC_SAFETY_SETTING,
         SETTING_GUIDANCE_VOLUME,
         SETTING_GUIDANCE_VOICE,
         SETTING_TRAFFIC_ANNOUNCEMENT,
         SETTING_TOLL_BOTH_GUIDE,
         SETTING_BORDER_CROSSING,
         SETTING_TRAFFIC_ICON
      };

      Candera::UInt32 _currentGuidanceVolume;
      typedef ListItemBase<GuidanceSettingListItemValue> GuidanceSettingListItem;
      std::vector<GuidanceSettingListItem> _guidanceSettingList;
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      void updateGuidanceVolume(const bool incrementVolume);
      void setMuteButtonStatus(bool isMute);

      FEATSTD_MAKE_CLASS_UNCOPYABLE(GuidanceSettingsHandler);
};


#endif // HALL_TO_MDW_COM
#endif // GUIDANCE_SETTINGS_HANDLER_H
