/* ***************************************************************************************
* FILE:          WaypointListHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WaypointListHandler.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_WAYPOINT_LIST_HANDLER_H)
#define _WAYPOINT_LIST_HANDLER_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "List/Data/ListDataProviderDistributor.h"
#include "ListRegistry.h"
#include "Candera/System/MemoryManagement/SharedPointer.h"
#include "NavMiddleware.h"
#include "Common/Util/HMIModelDefines.h"
#include "Common/Util/NavMiddlewareUtils.h"
#include "Common/Util/StaticListHandlerBase.h"
#include "Common/Util/HMIModelIncludes.h"

class WaypointListHandler : public HMIModelBase, public ListImplementation
{
   public:

      WaypointListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~WaypointListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ROUTE_WAYPOINTINFOS_CHANGED, onPropertyUpdateRouteWaypointInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ROUTE_ARRIVALINFOS_CHANGED, onPropertyUpdateArrivalInfosChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_STATE_CHANGED, onPropertyUpdateGuidanceStateChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      void onPropertyUpdateRouteWaypointInfoChanged();
      void onPropertyUpdateArrivalInfosChanged();
      void onPropertyUpdateGuidanceStateChanged();
      void checkForSkipWaypoints(bool, unsigned int);

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE_NOTRACE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(WaypointDeleteReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(ShowPopupTextMsg)
      ON_COURIER_MESSAGE_NOTRACE(SkipWaypointReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(ShowWaypointListViewReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(WaypointInsertReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS();

      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      bool onCourierMessage(const WaypointDeleteReqMsg& oMsg);
      bool onCourierMessage(const ShowPopupTextMsg& oMsg);
      bool onCourierMessage(const SkipWaypointReqMsg& oMsg);
      bool onCourierMessage(const ShowWaypointListViewReqMsg& oMsg);
      bool onCourierMessage(const WaypointInsertReqMsg& oMsg);

   private:
      bool _isWaypointListShown;

      unsigned int _listId;
      unsigned int _startIndex;
      unsigned int _listSize;

      ::std::vector<navmiddleware::DestinationMemoryItem::IdElement> _waypointElementId;
      DataBindingItem<MultiLinePopupTextDataBindingSource> _multiLinePopupText;

      virtual tSharedPtrDataProvider getListDataProvider();
};


#endif
