/* ***************************************************************************************
* FILE:          RouteListHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RouteListHandler.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_ROUTE_LIST_HANDLER_H)
#define _ROUTES_LIST_HANDLER_H

#include "AppHmi_NavigationStateMachine.h"
#include "ListRegistry.h"
#include "Common/Util/HMIModelIncludes.h"        // Includes other data model related header files

class RouteListHandler : public HMIModelBase, public ListImplementation
{
   public:

      RouteListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~RouteListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ROUTE_LIST_INVALIDATE, onPropertyUpdateRouteListInvalidate)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ROUTE_LIST_INFO_CHANGED, onPropertyUpdateRouteListInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_STATE_CHANGED, onPropertyUpdateGuidanceStateChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      void onPropertyUpdateRouteListInfoChanged();
      void onPropertyUpdateRouteListInvalidate();
      void onPropertyUpdateGuidanceStateChanged();

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_HARD_RESTRICTION_STATUS_CHANGED, onPropertyUpdateHardRestrictionStatusChanged)
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE_NOTRACE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE(ShowRouteListViewReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS();

      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      bool onCourierMessage(const ShowRouteListViewReqMsg& oMsg);
      bool onPropertyUpdateHardRestrictionStatusChanged();

   private:

      tSharedPtrDataProvider getShowRouteListDataProvider();
      tSharedPtrDataProvider getBlockRouteListDataProvider();
      inline void sendListLoadingStatus();
      void sendRouteListData(tSharedPtrDataProvider& listDataProvider);
      void updateRouteListData();
      void recalculateWithBlockedRoute();
      void onBlockRouteListSelection(unsigned int listIndex);
      int getNavmidIndexInRouteList(int hmiIndex);
      void getFullTurnlistTurnDataItem(ShowRouteListItemData& item, ::std::vector<navmiddleware::RouteListInfos::RouteListElementInfo>::const_iterator info);
      void getTurnlistMessageDistance(ShowRouteListItemData& item, ::std::vector<navmiddleware::RouteListInfos::RouteListElementInfo>::const_iterator info);
      bool getRouteSpecificIcon(ShowRouteListItemData& item, ::std::vector<navmiddleware::RouteListInfos::RouteListElementInfo>::const_iterator info);
      void UpdateRouteSelectionActivateImage(unsigned int firstSelectionIndex, unsigned int lastSelectionIndex);
      bool ShowBlockUnblockTextReqMsg(bool isShowBlockText);
      inline void enableRouteCalcButton(bool isEnabled = true);
      void onAvoidElementStatusChange(const navmiddleware::RouteListInfos::AvoidElementsStatus& avoidElementStatus);

      DataBindingItem<ShowRouteListItemDataBindingSource> _showRouteListItem;
      DataBindingItem<BlockRouteListItemDataBindingSource> _blockRouteListItem;
      DataBindingItem<GuidanceBlockUnblockButtonDataBindingSource> _guidanceBlockUnblockButton;
      DataBindingItem<MultiLinePopuptextDataBindingSource> _PopupText;

      unsigned int _listStartIndex;
      unsigned int _windowElementSize;
      unsigned int _listId;
      int _firstSelectionIndex;
      int _lastSelectionIndex;
      unsigned int _currentWindowStartIndex;
      unsigned int _routeListSize;

      bool _isRouteListShown;
      bool _isblockrouteListSelectionActive;
      bool _listSelectionIndex;
      bool _resetSelectionValue;
      bool _recalculateRouteSelected;
      bool _isStartRouteActive;
      bool _isListInvalidated;    // Set to true when list invalidated property update is received from Navmiddleware
      bool _isListRequested;      // Set to true when request is received from list widget to provide list data
      bool _hasRoadNumberImages;  // Set to true when road number images are available from navmiddleware
      navmiddleware::RouteListInfos::AvoidElementsStatus _avoidElementStatus;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(RouteListHandler);
};


#endif
