/**************************************************************************************
* @file         : RouteDataUtils.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "App/datapool/NaviDataPoolConfig.h"
#include "RouteDataUtils.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/RouteDataUtils.cpp.trc.h"
#endif
using namespace navmiddleware;
//Define constant variable for size of turn list icon data
static const unsigned int TURNLIST_ICONS_DATA_SIZE = navmiddleware::RouteListInfos::TURN_LIST_ICON_TYPE_INVALID + 1;
static const unsigned int TURNLIST_WAYPOINT_DATA_SIZE = 11 + 1; // 8 waypoint + 1 Destination + 3 Add as Destination
bool VEHICLE_PROFILE_CHANGED = false;

const char* turnListIconsDataLeftSideDriveCarMark[TURNLIST_ICONS_DATA_SIZE] =
{
   //00 - roundabout exit straight
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-4L_normal",
   //01 - roundabout exit halfright
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-5L_normal",
   //02 - roundbout exit right
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-6L_normal",
   //03 - roundabout exit sharpright
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-7L_normal",
   //04 - roundabout exit back
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-8L_normal",
   //05 - roundabout exit sharpleft
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-1L_normal",
   //06 - roundabout exit left
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-2L_normal",
   //07 - roundabout exit halfleft
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-3L_normal",
   //08 - keep left
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_C-1L_normal",
   //09 -keep right
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_C-1R_normal",
   //10 - turn straight
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_1_normal",
   //11 - turn halfright
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_2R_normal",
   //12 - turn right
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_3R_normal",
   //13 - turn sharpright
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_4R_normal",
   //14 - uturn left
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_5L_normal",
   //15 - turn sharpleft
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_4L_normal",
   //16 - turn left
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_3L_normal",
   //17 - turn halfleft
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_2L_normal",
   //18 - exit left
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_2L_Exit_normal",
   //19 - exit right
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_2R_Exit_normal",
   //20 - uturn right
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_5R_normal",
   //21 - motorway intersection
   "AppHmi_NavigationModule#Images#N_RouteList#Icon_MotorwayJunction_normal",
   //22 - border crossing
   "AppHmi_NavigationModule#Images#N_RouteList#Icon_BorderCrossing_normal",
   //23 - destination flag -- dummy for waypoint flag with index
   "AppHmi_NavigationModule#Images#N_RouteList#Icon_TrafficList#IconTrafficList_2060_e_normal",
   //24 - destination flag
   "AppHmi_NavigationModule#Images#N_RouteList#Icon_TrafficList#IconTrafficList_2060_e_normal",
   //25 - Service access
   "AppHmi_NavigationModule#Images#N_RouteList#Icon_ServiceAccess_normal",
   //26 - Invalid
   ""
};


const char* turnListIconsDataRightSideDriveCarMark[TURNLIST_ICONS_DATA_SIZE] =
{
   //00 - roundabout exit straight
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-4R_normal",
   //01 - roundabout exit halfright
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-3R_normal",
   //02 - roundbout exit right
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-2R_normal",
   //03 - roundabout exit sharpright
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-1R_normal",
   //04 - roundabout exit back
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-8R_normal",
   //05 - roundabout exit sharpleft
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-7R_normal",
   //06 - roundabout exit left
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-6R_normal",
   //07 - roundabout exit halfleft
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-5R_normal",
   //08 - keep left
   turnListIconsDataLeftSideDriveCarMark[8],
   //09 -keep right
   turnListIconsDataLeftSideDriveCarMark[9],
   //10 - turn straight
   turnListIconsDataLeftSideDriveCarMark[10],
   //11 - turn halfright
   turnListIconsDataLeftSideDriveCarMark[11],
   //12 - turn right
   turnListIconsDataLeftSideDriveCarMark[12],
   //13 - turn sharpright
   turnListIconsDataLeftSideDriveCarMark[13],
   //14 - uturn left
   turnListIconsDataLeftSideDriveCarMark[14],
   //15 - turn sharpleft
   turnListIconsDataLeftSideDriveCarMark[15],
   //16 - turn left
   turnListIconsDataLeftSideDriveCarMark[16],
   //17 - turn halfleft
   turnListIconsDataLeftSideDriveCarMark[17],
   //18 - exit left
   turnListIconsDataLeftSideDriveCarMark[18],
   //19 - exit right
   turnListIconsDataLeftSideDriveCarMark[19],
   //20 - uturn right
   turnListIconsDataLeftSideDriveCarMark[20],
   //21 - motorway intersection
   turnListIconsDataLeftSideDriveCarMark[21],
   //22 - border crossing
   turnListIconsDataLeftSideDriveCarMark[22],
   //23 - destination flag -- dummy for waypoint flag with index
   turnListIconsDataLeftSideDriveCarMark[23],
   //24 - destination flag
   turnListIconsDataLeftSideDriveCarMark[24],
   //25 - Service access
   turnListIconsDataLeftSideDriveCarMark[25],
   //26 - Invalid
   turnListIconsDataLeftSideDriveCarMark[26]
};


const char* turnListIconsDataLeftSideDrive[TURNLIST_ICONS_DATA_SIZE] =
{
   //00 - roundabout exit straight
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-4L_normal",
   //01 - roundabout exit halfright
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-5L_normal",
   //02 - roundbout exit right
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-6L_normal",
   //03 - roundabout exit sharpright
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-7L_normal",
   //04 - roundabout exit back
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-8L_normal",
   //05 - roundabout exit sharpleft
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-1L_normal",
   //06 - roundabout exit left
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-2L_normal",
   //07 - roundabout exit halfleft
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-3L_normal",
   //08 - keep left
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_C-1L_normal",
   //09 -keep right
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_C-1R_normal",
   //10 - turn straight
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_1_normal",
   //11 - turn halfright
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_2R_normal",
   //12 - turn right
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_3R_normal",
   //13 - turn sharpright
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_4R_normal",
   //14 - uturn left
   //"AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_Grey_5L_normal",
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_5L_normal",   // ToDo: Confirm if greyed out images are needed
   //15 - turn sharpleft
   //"AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_Grey_4L_normal",
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_4L_normal",   // ToDo: Confirm if greyed out images are needed
   //16 - turn left
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_3L_normal",
   //17 - turn halfleft
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_2L_normal",
   //18 - exit left
   //"AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_2L_Exit_normal",
   "AppHmi_NavigationModule#Images#N_RouteList#Icon_MotorwayExit_L_normal",   // ToDo: Confirm if correct images are used
   //19 - exit right
   //"AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_2R_Exit_normal",
   "AppHmi_NavigationModule#Images#N_RouteList#Icon_MotorwayExit_R_normal",    // ToDo: Confirm if correct images are used
   //20 - uturn right
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_5R_normal",
   //21 - motorway intersection
   "AppHmi_NavigationModule#Images#N_RouteList#Icon_MotorwayJunction_normal",
   //22 - border crossing
   "AppHmi_NavigationModule#Images#N_RouteList#Icon_BorderCrossing_normal",
   //23 - destination flag -- dummy for waypoint flag with index
   "AppHmi_NavigationModule#Images#N_RouteList#Icon_TrafficList#IconTrafficList_2060_e_normal",
   //24 - destination flag
   "AppHmi_NavigationModule#Images#N_RouteList#Icon_TrafficList#IconTrafficList_2060_e_normal",
   //25 - Service access
   "AppHmi_NavigationModule#Images#N_RouteList#Icon_ServiceAccess_normal",
   //26 - Invalid
   ""
};


const char* turnListIconsDataRightSideDrive[TURNLIST_ICONS_DATA_SIZE] =
{
   //00 - roundabout exit straight
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-4R_normal",
   //01 - roundabout exit halfright
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-3R_normal",
   //02 - roundbout exit right
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-2R_normal",
   //03 - roundabout exit sharpright
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-1R_normal",
   //04 - roundabout exit back
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-8R_normal",
   //05 - roundabout exit sharpleft
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-7R_normal",
   //06 - roundabout exit left
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-6R_normal",
   //07 - roundabout exit halfleft
   "AppHmi_NavigationModule#Images#N_RouteList#IconTBT_Route_RA-5R_normal",
   //08 - keep left
   turnListIconsDataLeftSideDrive[8],
   //09 -keep right
   turnListIconsDataLeftSideDrive[9],
   //10 - turn straight
   turnListIconsDataLeftSideDrive[10],
   //11 - turn halfright
   turnListIconsDataLeftSideDrive[11],
   //12 - turn right
   turnListIconsDataLeftSideDrive[12],
   //13 - turn sharpright
   turnListIconsDataLeftSideDrive[13],
   //14 - uturn left
   turnListIconsDataLeftSideDrive[14],
   //15 - turn sharpleft
   turnListIconsDataLeftSideDrive[15],
   //16 - turn left
   turnListIconsDataLeftSideDrive[16],
   //17 - turn halfleft
   turnListIconsDataLeftSideDrive[17],
   //18 - exit left
   turnListIconsDataLeftSideDrive[18],
   //19 - exit right
   turnListIconsDataLeftSideDrive[19],
   //20 - uturn right
   turnListIconsDataLeftSideDrive[20],
   //21 - motorway intersection
   turnListIconsDataLeftSideDrive[21],
   //22 - border crossing
   turnListIconsDataLeftSideDrive[22],
   //23 - destination flag -- dummy for waypoint flag with index
   turnListIconsDataLeftSideDrive[23],
   //24 - destination flag
   turnListIconsDataLeftSideDrive[24],
   //25 - Service access
   turnListIconsDataLeftSideDrive[25],
   //26 - Invalid
   turnListIconsDataLeftSideDrive[26]
};


static const char* const _WaypointImagePath[TURNLIST_WAYPOINT_DATA_SIZE][5] =
{
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_Destination_1_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Destination_1_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Destination_1_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Destination_1_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Destination_1_normal" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint1_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint1_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint1_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint1_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint1_normal" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint2_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint2_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint2_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint2_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint2_normal" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint3_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint3_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint3_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint3_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint3_normal" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint4_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint4_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint4_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint4_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint4_normal" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint5_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint5_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint5_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint5_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoint5_normal" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_6_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_6_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_6_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_6_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_6_normal" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_7_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_7_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_7_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_7_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_7_normal" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_8_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_8_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_8_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_8_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_8_normal" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_9_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_9_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_9_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_9_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_9_normal" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_10_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_10_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_10_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_10_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_10_normal" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_11_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_11_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_11_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_11_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Waypoints_11_normal" }
};


static const char* const SpecificTurnListIcon[TURNLIST__ICON_MAX][2] =
{
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_Ferry_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_Ferry_active" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_AutoTrain_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_AutoTrain_active" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_HighwayEntry_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_HighwayEntry_active" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_HighwayExit_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_HighwayExit_active" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_SeasonRestricted_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_SeasonRestricted_active" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_TimeRestricted_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_TimeRestricted_active" },
   { "AppHmi_NavigationModule#Images#N_RouteList#Icon_TollRoad_normal", "AppHmi_NavigationModule#Images#N_RouteList#Icon_TollRoad_active" }
};


void setWaypointFlag(ShowRouteListItemData& item, const unsigned int index)
{
   ETG_TRACE_USR4(("RouteDataUtils::setWaypointFlag(), Index : %d", index));
   if (index < TURNLIST_WAYPOINT_DATA_SIZE)
   {
      item.mTurnIconActiveBitmap = ImageLoader::getAssetBitmapImage(_WaypointImagePath[index][0]);
   }
   else
   {
      ETG_TRACE_ERR(("RouteDataUtils::setWaypointFlag : Out Of Bound Index received %d", index));
   }
}


void setTurnIcon(ShowRouteListItemData& item, const unsigned int iconType, const char* const turnIconDataArray[])
{
   ETG_TRACE_USR4(("RouteDataUtils::setTurnIcon, icon type : %d", iconType));
   if ((iconType < TURNLIST_ICONS_DATA_SIZE) && (turnIconDataArray != NULL))
   {
      item.mTurnIconActiveBitmap = ImageLoader::getAssetBitmapImage(turnIconDataArray[iconType]);
   }
   else
   {
      ETG_TRACE_ERR(("RouteDataUtils setTurnIcon : Out Of Bound Index received %d %p", iconType, turnIconDataArray));
   }
}


void getTurnlistIcon(const navmiddleware::RouteListInfos::RouteListElementInfo& info, ShowRouteListItemData& item, bool isCarMark)
{
   ETG_TRACE_USR4(("RouteDataUtils::getTurnlistIcon"));

   //Only handle when RouteListInfos is valid
   if (info.m_turnListIconType != navmiddleware::RouteListInfos::TURN_LIST_ICON_TYPE_INVALID)
   {
      if (info.m_turnListIconType == navmiddleware::RouteListInfos::TURN_LIST_ICON_TYPE_WAYPOINT_FLAG ||
            info.m_turnListIconType == navmiddleware::RouteListInfos::TURN_LIST_ICON_TYPE_DESTINATION_FLAG)
      {
         //Use Zero if its destination, else get waypoint number from m_destinationOfSegment
         const unsigned int waypointIndex = info.m_turnListIconType == navmiddleware::RouteListInfos::TURN_LIST_ICON_TYPE_DESTINATION_FLAG ? 0 : info.m_destinationOfSegment;
         setWaypointFlag(item, waypointIndex);
      }
      else
      {
         if (info.m_trafficSense == TRAFFIC_SENSE__UNKNOWN)
         {
            ETG_TRACE_ERR(("RouteDataUtils getTurnlistIcon : Unknown traffic sense , no turn icons will be loaded %d", info.m_trafficSense));
         }
         else
         {
            const char* const* TurnIconDataArrayWithTrafficDirectionSense;
            ETG_TRACE_USR4(("RouteDataUtils::getTurnlistIcon, Traffic sense : %d", info.m_trafficSense));
            if (isCarMark)
            {
               TurnIconDataArrayWithTrafficDirectionSense = (info.m_trafficSense == TRAFFIC_SENSE__LEFTHAND_TRAFFIC) ? turnListIconsDataLeftSideDriveCarMark : turnListIconsDataRightSideDriveCarMark;
            }
            else
            {
               TurnIconDataArrayWithTrafficDirectionSense = (info.m_trafficSense == TRAFFIC_SENSE__LEFTHAND_TRAFFIC) ? turnListIconsDataLeftSideDrive : turnListIconsDataRightSideDrive;
            }
            setTurnIcon(item, info.m_turnListIconType, TurnIconDataArrayWithTrafficDirectionSense);
         }
      }
   }
}


void getSpecificTurnListIconUtil(ShowRouteListItemData& item, int specificIcon)
{
   ETG_TRACE_USR4(("RouteDataUtils::getSpecificTurnListIconUtil, Icon index : %d", specificIcon));

   item.mRoadIconActiveBitmap = ImageLoader::getAssetBitmapImage(SpecificTurnListIcon[specificIcon][0]);
}


void recalculateRouteGuidance(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore , bool showDestGuidance)
{
   ETG_TRACE_USR4(("RouteDataUtils::recalculateRouteGuidance, showDestGuidance : %d", showDestGuidance));

   static bool isDestGuidanceShown = false;

   // if (!VEHICLE_PROFILE_CHANGED)
   // {
   //    if ((EXT_bIsGuidanceActive == true) && (showDestGuidance == true))
   //    {
   //       // Corresponds to scene with options - Replace destination / Add waypoint / Add destination
   //       POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(AddressInputGuidancetouchMsg)(SHOW_DESTINATION_GUIDANCE)));
   //    }
   //    else if (navMiddleware.getRouteOptionSettings().getMoreRoutesType() == navmiddleware::settings::MORE_ROUTES_TYPE_ALTERNATIVE)
   //    {
   //       // The below message is handled in SM where StartRouteGuidanceReqMsg is fired (and latter msg is handled in CalculateRouteHandler)
   //       // For single/alternative route, both route calculation and guidance is started
   //       // After calculating route popup is closed, event is fired in state machine to make transition from N_Dest_Guidance scene to N_Map_Active_RG scene
   //       POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(StartRouteGuidanceReqMsg)()));
   //    }
   //    else
   //    {
   //       // The below message is handled in SM where signal is fired to show Map scene.
   //       POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(AddressInputGuidancetouchMsg)(SHOW_MULTIPLE_ROUTE)));

   //       // For multiple routes, only route calculation is done.
   //       // Guidance is started by the user after selecting one of the 3 routes (RouteStartGuidanceReqMsg in CalculateRouteHandler)
   //       POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(StartRouteGuidanceReqMsg)()));
   //    }
   // }
   // else
   // {
   //    // The below condition is used when Vehicle profile values are changed during ActiveRG & when user tries to add a new destination.
   //    // N_Dest_Guidance scene shall be displayed instead of Vehcile Information scene.
   //    // Vehicle Information scene shall be displayed when the ongoing RG is ended/stopped.
   //    if ((EXT_bIsGuidanceActive == true) && (showDestGuidance == true))
   //    {
   //       POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(AddressInputGuidancetouchMsg)(SHOW_DESTINATION_GUIDANCE)));
   //       isDestGuidanceShown = true;
   //    }
   //    // The below condition is used to start guidance for a single route type on Add as Waypoint/ Destination when vehicle profile is changed during active RG
   //    else if ((navMiddleware.getRouteOptionSettings().getMoreRoutesType() == navmiddleware::settings::MORE_ROUTES_TYPE_ALTERNATIVE) && (isDestGuidanceShown == true))
   //    {
   //       isDestGuidanceShown = false;
   //       POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(StartRouteGuidanceReqMsg)()));
   //    }
   //    // The below condition is used to start guidance for a multiple route type on Add as Waypoint/ Destination when vehicle profile is changed during active RG
   //    else if ((navMiddleware.getRouteOptionSettings().getMoreRoutesType() == navmiddleware::settings::MORE_ROUTES_TYPE_MULTIPLE) && (isDestGuidanceShown == true))
   //    {
   //       isDestGuidanceShown = false;
   //       POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(AddressInputGuidancetouchMsg)(SHOW_MULTIPLE_ROUTE)));
   //       POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(StartRouteGuidanceReqMsg)()));
   //    }
   //    else
   //    {
   //       POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(VehicleProfileChangedResMsg)()));
   //    }
   // }
   if ((EXT_bIsGuidanceActive == true) && (showDestGuidance == true))
   {
      // Corresponds to scene with options - Replace destination / Add waypoint / Add destination
      POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(AddressInputGuidancetouchMsg)(SHOW_DESTINATION_GUIDANCE)));
      isDestGuidanceShown = true;
   }
   else if (navMiddleware.getRouteOptionSettings().getMoreRoutesType() == navmiddleware::settings::MORE_ROUTES_TYPE_ALTERNATIVE)
   {
      if ((!VEHICLE_PROFILE_CHANGED) || (true == isDestGuidanceShown))
      {
         isDestGuidanceShown = false;
         // The below message is handled in SM where StartRouteGuidanceReqMsg is fired (and latter msg is handled in CalculateRouteHandler)
         // For single/alternative route, both route calculation and guidance is started
         // After calculating route popup is closed, event is fired in state machine to make transition from N_Dest_Guidance scene to N_Map_Active_RG scene
         POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(StartRouteGuidanceReqMsg)()));
      }
      else
      {
         POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(VehicleProfileChangedResMsg)()));
      }
   }
   else if (navMiddleware.getRouteOptionSettings().getMoreRoutesType() == navmiddleware::settings::MORE_ROUTES_TYPE_MULTIPLE)
   {
      if ((!VEHICLE_PROFILE_CHANGED) || (true == isDestGuidanceShown))
      {
         isDestGuidanceShown = false;
         // The below message is handled in SM where signal is fired to show Map scene.
         POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(AddressInputGuidancetouchMsg)(SHOW_MULTIPLE_ROUTE)));
         // For multiple routes, only route calculation is done.
         // Guidance is started by the user after selecting one of the 3 routes (RouteStartGuidanceReqMsg in CalculateRouteHandler)
         POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(StartRouteGuidanceReqMsg)()));
      }
      else
      {
         POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(VehicleProfileChangedResMsg)()));
      }
   }
   else
   {
      // do nothing
   }
}
