/**************************************************************************************
* @file         : MapPickingOptionHandler.h
* @author       : ECG5- Prieethi Narayanaswamy
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef ROUTE_GUIDANCE_HANDLER_H
#define ROUTE_GUIDANCE_HANDLER_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "Common/DataModel/ListRegistry.h"

#ifdef HALL_TO_MDW_COM

class MapPickingOptionHandler : public HMIModelBase, public ListImplementation
{
   public:
      MapPickingOptionHandler(navmiddleware::NavMiddleware& _navMiddleware, InfoStore& _infoStore);
      virtual ~MapPickingOptionHandler();
      virtual void initialize();
      virtual void deinitialize();

      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_STATE_CHANGED, onPropertyUpdateGuidanceStateChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(SetWayPointEnableReqMsg)
      ON_COURIER_MESSAGE(ResetTripCountReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      bool onCourierMessage(const SetWayPointEnableReqMsg& oMsg);
      bool onCourierMessage(const ResetTripCountReqMsg& oMsg);
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      void onPropertyUpdateGuidanceStateChanged();
   private:
      bool _isAddAsWaypointOptionEnabled;
      bool _isReplaceDestination; // Set to true when Replace destination option is selected by the user
      int _mapPickListSize;   // Used to decide the list size based on if "Add Waypoints" is available or not and then show the Add to Destination button

      DataBindingItem<MultiLinePopuptextDataBindingSource> _PopupText;
      enum RouteGuidanceCoordinatesValue
      {
         GUIDANCE_COORDINATES_REPLACEDEST,
         GUIDANCE_COORDINATES_WAYPOINT,
         GUIDANCE_COORDINATES_DETAILS,
         GUIDANCE_COORDINATES_POISAROUND,
         GUIDANCE_COORDINATES_ADDDEST
      };

      FEATSTD_MAKE_CLASS_UNCOPYABLE(MapPickingOptionHandler);

      typedef ListItemBase<RouteGuidanceCoordinatesValue> RouteGuidanceCoordinates;
      DataBindingItem<SwitchindexDataBindingSource>        _switchIndexData;
      std::vector<RouteGuidanceCoordinates> _RouteGuidanceCoordinates;
      // Incoming courier messages from HMI
      //COURIER_MSG_MAP_BEGIN(0)
      //   ON_COURIER_MESSAGE(ButtonReactionMsg)
      //COURIER_MSG_MAP_END()
      // void setVisibleButtons();
};


#endif // ROUTE_GUIDANCE_HANDLER_H
#endif // ROUTE_GUIDANCE_HANDLER_H
