/* ***************************************************************************************
* @file:        : StackedPOIOnMapListHandler.h
* @author       : ECG5-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(STACKED_POI_LIST_HANDLER_ON_MAP_H)
#define STACKED_POI_LIST_HANDLER_ON_MAP_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"


#ifdef HALL_TO_MDW_COM
class StackedPOIOnMapListHandler : public HMIModelBase
{
   public:

      StackedPOIOnMapListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~StackedPOIOnMapListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_PICKING_DETAIL_RESULT_AVAILABLE, onPropertyUpdatePickingDetailResultsAvailable)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      bool onPropertyUpdatePickingDetailResultsAvailable();

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(ListDateProviderReqMsg)
      COURIER_MSG_MAP_END()

      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      bool onCourierMessage(const ListDateProviderReqMsg& oMsg);

   private:

      tSharedPtrDataProvider getListDataProvider();
      unsigned int _listId;
      unsigned int _startIndex;
      unsigned int _windowSize;
      FEATSTD_MAKE_CLASS_UNCOPYABLE(StackedPOIOnMapListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // STACKED_POI_LIST_HANDLER_ON_MAP_H
