/**************************************************************************************
* @file         : DestinationDataUtils.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "DestinationDataUtils.h"
#include "AddressDetailedInfo/AddressDetailedInfo.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/DestinationDataUtils.cpp.trc.h"
#endif

//std::map<enDestinationMainListItemValue, std::string> _enableDestinationIcons;
//std::map<enDestinationMainListItemValue, std::string> _disableDestinationIcons;
static bool _isUncertainCharacter = false;
static bool _isPredictionEnable = false;
static unsigned int _numOfCharactersPOI = 0;
static unsigned int _numOfCharactersStreetAddress = 0;
static unsigned int _numOfCharactersAddressBook = 0;

static const unsigned char UTF8_LOOK_TABLE[] =
{
   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
   2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
   3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 1, 1
};


static const IconNames directionIconPath[17] =
{
   // _activeBitmap, _activeFocusesBitmap, _normalBitmap, _focusedBitmap, _pressedBitmap
   // NORTH
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionN_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionN_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionN_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionN_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionN_1_touched"
   },
   // NORTH_NORTH_EAST
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNE_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNE_1_touched"
   },
   // NORTH_EAST
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNE_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNE_1_touched"
   },
   // EAST_NORTH_EAST
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionE_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionE_1_touched"
   },
   // EAST
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionE_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionE_1_touched"
   },
   // EAST_SOUTH_EAST
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSE_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSE_1_touched"
   },
   // SOUTH_EAST
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSE_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSE_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSE_1_touched"
   },
   // SOUTH_SOUTH_EAST
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionS_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionS_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionS_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionS_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionS_1_touched"
   },
   // SOUTH
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionS_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionS_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionS_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionS_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionS_1_touched"
   },
   // SOUTH_SOUTH_WEST
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSW_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSW_1_touched"
   },
   // SOUTH_WEST
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSW_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionSW_1_touched"
   },
   // WEST_SOUTH_WEST
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionW_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionW_1_touched"
   },
   // WEST
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionW_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionW_1_touched"
   },
   // WEST_NORTH_WEST
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNW_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNW_1_touched"
   },
   // NORTH_EAST
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNW_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNW_1_touched"
   },
   // NORTH_NORTH_WEST
   {
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNW_1_normal",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNW_1_touched",
      "AppHmi_NavigationModule#Images#N_Poi_List1#Icon_POIDirectionNW_1_touched"
   },
   // INVAILD
   { "", "", "", "", "" }
};


//static const int MAX_NUMBER_OF_CHARCHING_STATION_ICON = 18;
//static const IconNames _chargingStationIconPath[MAX_NUMBER_OF_CHARCHING_STATION_ICON + 1] =
//{
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge1_blue_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge1_bluecrossed_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge1_green_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge1_grey_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge1_greycrossed_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge1_red_disabled_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge1_red_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge1_unknown_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge1_yellow_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge2_blue_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge2_bluecrossed_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge2_green_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge2_grey_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge2_greycrossed_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge2_red_disabled_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge2_red_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge2_unknown_e", "", "" },
//   { "", "", "Bitmaps##AIVIResources#Icon_Addressbook#IconAddressbook_EVcharge2_yellow_e", "", "" },
//   // INVAILD
//   { "", "", "", "", "" }
//};

//
//IconNames getChargingStationIcon(unsigned int idx)
//{
//   idx = idx % MAX_NUMBER_OF_CHARCHING_STATION_ICON;
//   return _chargingStationIconPath[idx];
//}


//void initializeEnableDisableDestinationIconData(bool isPivi)
//{
//   //Enable button icons
//   if (isPivi)
//   {
//      const std::string resPath = "Bitmaps##PIVIResources#Icon_Topmenu#";
//
//      _enableDestinationIcons[MAIN_LIST_HOME] = resPath + "IconTopmenu_Destination_Home_e";
//      _enableDestinationIcons[MAIN_LIST_STREET_ADDRESS] = resPath + "IconTopmenu_Destination_Address_e";
//      _enableDestinationIcons[MAIN_LIST_POI] = resPath + "IconTopmenu_Destination_POI_e";
//      _enableDestinationIcons[MAIN_LIST_PREVIOUS_DESTINATION] = resPath + "IconTopmenu_Destination_Destination_e";
//      _enableDestinationIcons[MAIN_LIST_WORK] = resPath + "IconTopmenu_Destination_Work_e";
//      _enableDestinationIcons[MAIN_LIST_ADDRESS_BOOK] = resPath + "IconTopmenu_Destination_AdressBook_e";
//      _enableDestinationIcons[MAIN_LIST_CITY_CENTER] = resPath + "IconTopmenu_Destination_CityCenter_e";
//      _enableDestinationIcons[MAIN_LIST_NISSAN_CON_SERVICE] = resPath + "IconTopmenu_Destination_ConnectedSearch_Destination_e";
//      _enableDestinationIcons[MAIN_LIST_INTERSECTION] = resPath + "IconTopmenu_Destination_Intersection_e";
//      _enableDestinationIcons[MAIN_LIST_PHONE_NUMBER] = resPath + "IconTopmenu_Destination_Phone_e";
//      _enableDestinationIcons[MAIN_LIST_STORED_ROUTES] = resPath + "IconTopmenu_Destination_StoredRoutes_e";
//      _enableDestinationIcons[MAIN_LIST_FREEWAY_EXIT] = resPath + "IconTopmenu_Destination_Freeway_e";
//      _enableDestinationIcons[MAIN_LIST_BY_MAP] = resPath + "IconTopmenu_Destination_ByMap_e";
//      _enableDestinationIcons[MAIN_LIST_LATLONG] = resPath + "IconTopmenu_Destination_LatLong_e";
//      _enableDestinationIcons[MAIN_LIST_SXM_TRAVEL_LINK] = resPath + "IconTopmenu_Destination_Freeway_e";
//      //Disable button icons Currenly disable images are not available, once images will be delivered then will replace the images
//      _disableDestinationIcons[MAIN_LIST_HOME] = resPath + "IconTopmenu_Destination_Home_e";
//      _disableDestinationIcons[MAIN_LIST_STREET_ADDRESS] = resPath + "IconTopmenu_Destination_Address_e";
//      _disableDestinationIcons[MAIN_LIST_POI] = resPath + "IconTopmenu_Destination_POI_e";
//      _disableDestinationIcons[MAIN_LIST_PREVIOUS_DESTINATION] = resPath + "IconTopmenu_Destination_Destination_e";
//      _disableDestinationIcons[MAIN_LIST_WORK] = resPath + "IconTopmenu_Destination_Work_e";
//      _disableDestinationIcons[MAIN_LIST_ADDRESS_BOOK] = resPath + "IconTopmenu_Destination_AdressBook_e";
//      _disableDestinationIcons[MAIN_LIST_CITY_CENTER] = resPath + "IconTopmenu_Destination_CityCenter_e";
//      _disableDestinationIcons[MAIN_LIST_NISSAN_CON_SERVICE] = resPath + "IconTopmenu_Destination_ConnectedSearch_Destination_e";
//      _disableDestinationIcons[MAIN_LIST_INTERSECTION] = resPath + "IconTopmenu_Destination_Intersection_e";
//      _disableDestinationIcons[MAIN_LIST_PHONE_NUMBER] = resPath + "IconTopmenu_Destination_Phone_e";
//      _disableDestinationIcons[MAIN_LIST_STORED_ROUTES] = resPath + "IconTopmenu_Destination_StoredRoutes_e";
//      _disableDestinationIcons[MAIN_LIST_FREEWAY_EXIT] = resPath + "IconTopmenu_Destination_Freeway_e";
//      _disableDestinationIcons[MAIN_LIST_BY_MAP] = resPath + "IconTopmenu_Destination_ByMap_e";
//      _disableDestinationIcons[MAIN_LIST_LATLONG] = resPath + "IconTopmenu_Destination_LatLong_e";
//      _disableDestinationIcons[MAIN_LIST_SXM_TRAVEL_LINK] = resPath + "IconTopmenu_Destination_Freeway_e";
//   }
//   else
//   {
//      _enableDestinationIcons[MAIN_LIST_HOME] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_Home_e";
//      _enableDestinationIcons[MAIN_LIST_STREET_ADDRESS] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_Address_e";
//      _enableDestinationIcons[MAIN_LIST_POI] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_POI_e";
//      _enableDestinationIcons[MAIN_LIST_PREVIOUS_DESTINATION] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_PreviousDestinations_e";
//      _enableDestinationIcons[MAIN_LIST_WORK] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_Work_e";
//      _enableDestinationIcons[MAIN_LIST_ADDRESS_BOOK] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_AdressBook_e";
//      _enableDestinationIcons[MAIN_LIST_CITY_CENTER] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_CityCenter_e";
//      _enableDestinationIcons[MAIN_LIST_NISSAN_CON_SERVICE] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_ConnectedSearch_e";
//      _enableDestinationIcons[MAIN_LIST_INTERSECTION] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_Intersection_e";
//      _enableDestinationIcons[MAIN_LIST_PHONE_NUMBER] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_Phone_e";
//      _enableDestinationIcons[MAIN_LIST_STORED_ROUTES] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_StoredRoutes_e";
//      _enableDestinationIcons[MAIN_LIST_FREEWAY_EXIT] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_Freeway_e";
//      _enableDestinationIcons[MAIN_LIST_BY_MAP] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_ByMap_e";
//      _enableDestinationIcons[MAIN_LIST_LATLONG] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_LatLong_e";
//      _enableDestinationIcons[MAIN_LIST_SXM_TRAVEL_LINK] = "Bitmaps##AIVIResources#Icon_Topmenu#Information_SXMTrafficLink_e";
//      _enableDestinationIcons[MAIN_LIST_DOOR_TO_DOOR_NAVIGATION] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_Door2DoorNavi_e";
//      _enableDestinationIcons[MAIN_LIST_CHARGING_STATION] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_ChargeSpot_e";
//
//      //Disable button icons
//      _disableDestinationIcons[MAIN_LIST_HOME] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_Home_d";
//      _disableDestinationIcons[MAIN_LIST_STREET_ADDRESS] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_Address_d";
//      _disableDestinationIcons[MAIN_LIST_POI] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_POI_d";
//      _disableDestinationIcons[MAIN_LIST_PREVIOUS_DESTINATION] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_PreviousDestinations_d";
//      _disableDestinationIcons[MAIN_LIST_WORK] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_Work_d";
//      _disableDestinationIcons[MAIN_LIST_ADDRESS_BOOK] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_AdressBook_d";
//      _disableDestinationIcons[MAIN_LIST_CITY_CENTER] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_CityCenter_d";
//      _disableDestinationIcons[MAIN_LIST_NISSAN_CON_SERVICE] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_ConnectedSearch_d";
//      _disableDestinationIcons[MAIN_LIST_INTERSECTION] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_Intersection_d";
//      _disableDestinationIcons[MAIN_LIST_PHONE_NUMBER] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_Phone_d";
//      _disableDestinationIcons[MAIN_LIST_STORED_ROUTES] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_StoredRoutes_d";
//      _disableDestinationIcons[MAIN_LIST_FREEWAY_EXIT] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_Freeway_d";
//      _disableDestinationIcons[MAIN_LIST_BY_MAP] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_ByMap_d";
//      _disableDestinationIcons[MAIN_LIST_LATLONG] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_LatLong_d";
//      _disableDestinationIcons[MAIN_LIST_SXM_TRAVEL_LINK] = "Bitmaps##AIVIResources#Icon_Topmenu#Information_SXMTrafficLink_d";
//      _disableDestinationIcons[MAIN_LIST_DOOR_TO_DOOR_NAVIGATION] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_Door2DoorNavi_d";
//      _disableDestinationIcons[MAIN_LIST_CHARGING_STATION] = "Bitmaps##AIVIResources#Icon_Topmenu#Destination_ChargeSpot_d";
//   }
//}

//
//std::string getDestiantionIconData(enDestinationMainListItemValue item, bool visible)
//{
//   if (visible == true)
//   {
//      std::map<enDestinationMainListItemValue, std::string>::const_iterator iter = _enableDestinationIcons.find(item);
//      if ((iter != _enableDestinationIcons.end()) && !iter->second.empty())
//      {
//         return iter->second;
//      }
//   }
//   else
//   {
//      std::map<enDestinationMainListItemValue, std::string>::const_iterator iter = _disableDestinationIcons.find(item);
//      if ((iter != _disableDestinationIcons.end()) && !iter->second.empty())
//      {
//         return iter->second;
//      }
//   }
//   return "";
//}


IconNames getDirectionIcon(unsigned int idx)
{
   return directionIconPath[idx];
}


//DataBindingItem<FreeTextHitNumberDataBindingSource>& getFreeTextHitNumber()
//{
//   static DataBindingItem<FreeTextHitNumberDataBindingSource> sFreeTextHitNumber;
//   return sFreeTextHitNumber;
//}
//
//
//DataBindingItem<CNSpaceBtnEnabledDataBindingSource>& getCNSpaceBtnEnabled()
//{
//   static DataBindingItem<CNSpaceBtnEnabledDataBindingSource> cnSpaceBtnState;
//   return cnSpaceBtnState;
//}


unsigned int& getFreeTextScope()
{
   static unsigned int sFreeTextScope;
   return sFreeTextScope;
}


void setFreeTextScope(unsigned int freeTextScope)
{
   getFreeTextScope() = freeTextScope;
}


//bool sendFreeTextHitNumberData(Candera::String hitNumber)
//{
//   if ((*getFreeTextHitNumber()).mHitNumber != hitNumber)
//   {
//      (*getFreeTextHitNumber()).mHitNumber = hitNumber;
//      getFreeTextHitNumber().MarkItemModified(ItemKey::FreeTextHitNumber::HitNumberItem);
//      if (getFreeTextHitNumber().SendUpdate() == false)
//      {
//         ETG_TRACE_ERR(("sFreeTextHitNumber update failed!"));
//         return false;
//      }
//   }
//   return true;
//}

//
//bool setCNSpaceKeyEnable(bool status)
//{
//   if ((*getCNSpaceBtnEnabled()).mIsSpaceBtnEnabled != status)
//   {
//      (*getCNSpaceBtnEnabled()).mIsSpaceBtnEnabled = status;
//      getCNSpaceBtnEnabled().MarkItemModified(ItemKey::CNSpaceBtnEnabled::IsSpaceBtnEnabledItem);
//      if (getCNSpaceBtnEnabled().SendUpdate() == false)
//      {
//         ETG_TRACE_ERR(("cnSpaceBtnState update failed!"));
//         return false;
//      }
//   }
//   return true;
//}


bool cnGetHwrCandidateCharacterStatus()
{
   return _isUncertainCharacter;
}


void cnSetHwrCandidateCharacterStatus(bool isUncertainCharacter)
{
   _isUncertainCharacter = isUncertainCharacter;
}


bool cnGetPredictionStatus()
{
   return _isPredictionEnable;
}


//unsigned int cnGetNumOfCharacters(unsigned int type)
//{
//   unsigned int numOfCharacters = 0;
//   switch (type)
//   {
//      case EDIT_FIELD_POI:
//         numOfCharacters = _numOfCharactersPOI;
//         break;
//      case EDIT_FIELD_STREET_ADDRESS:
//         numOfCharacters = _numOfCharactersStreetAddress;
//         break;
//      case EDIT_FIELD_ADDRESS_BOOK:
//         numOfCharacters = _numOfCharactersAddressBook;
//         break;
//      default:
//         break;
//   }
//
//   return numOfCharacters;
//}


//void cnSetNumOfCharacters(unsigned int type, unsigned int num)
//{
//   switch (type)
//   {
//      case EDIT_FIELD_POI:
//         _numOfCharactersPOI = num;
//         break;
//      case EDIT_FIELD_STREET_ADDRESS:
//         _numOfCharactersStreetAddress = num;
//         break;
//      case EDIT_FIELD_ADDRESS_BOOK:
//         _numOfCharactersAddressBook = num;
//         break;
//      default:
//         break;
//   }
//}


std::vector<std::string>::size_type cnGetUTF8Character(const std::string& sourceStr, std::vector<std::string>& candidateCharacters)
{
   if (!sourceStr.empty())
   {
      const char* predictedWords = sourceStr.c_str();
      unsigned int wordSize = sourceStr.size();
      unsigned int pos = 0;
      for (unsigned int startPos = 0; wordSize > 0; wordSize -= pos)
      {
         pos = UTF8_LOOK_TABLE[(unsigned char)predictedWords[0]];
         candidateCharacters.push_back(sourceStr.substr(startPos, pos));
         startPos += pos;
         predictedWords += pos;
      }
   }
   else
   {
      ETG_TRACE_USR4(("The predicted character is empty!"));
   }

   return candidateCharacters.size();
}


void cnRemoveLastUTF8Character(std::string& sourceStr, std::vector<std::string>& candidateCharacters)
{
   std::string lastCharacter = candidateCharacters[candidateCharacters.size() - 1];
   sourceStr = sourceStr.substr(0, sourceStr.length() - lastCharacter.length());
}


void setPickedPOIDetailInfo(const navmiddleware::PickingResults::PickingResult& pickingResult, InfoStore& infostore)
{
   AddressDetailedInfo* poAddressInfo = AddressDetailedInfo::getInstance();
   if (poAddressInfo)
   {
      if (pickingResult.getPickingResultDetailPoi())
      {
         const navmiddleware::LocationAttributeInfos& locationInfos = pickingResult.getPickingResultDetailPoi()->m_locationAttributeInfos;
         poAddressInfo->FillAddressDetailedinfo(locationInfos);
         if (pickingResult.m_title.isValid() && pickingResult.m_title.getValue().size())
         {
            infostore.setAddressInfoDetailsName(pickingResult.m_title.getValue().c_str());
         }
      }
      if (pickingResult.getPickingResultDetailAddressBookPoi())
      {
         const navmiddleware::LocationAttributeInfos& locationInfos = pickingResult.getPickingResultDetailAddressBookPoi()->m_locationAttributeInfos;
         poAddressInfo->FillAddressDetailedinfo(locationInfos);
      }
   }
}
