/**************************************************************************************
* @file         : HMIModelNavDataUpdate.h
* @author       : ECG5-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef HMI_MODEL_NAV_DATA_UPDATE_H
#define HMI_MODEL_NAV_DATA_UPDATE_H

#include "Common/Util/HMIModelIncludes.h"

#if defined(HALL_TO_MDW_COM)

class HMIModelNavDataUpdate : public HMIModelBase
{
   public:
      HMIModelNavDataUpdate(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~HMIModelNavDataUpdate();

      virtual void initialize();
      virtual void deinitialize();
      virtual void recoverNavData();

      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_DEVICE_STATUS_CHANGED, onPropertyUpdateDeviceStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_UPDATE_PREPARATION_STATUS_CHANGED, onPropertyUpdatePreparationStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_UPDATE_INFO_CHANGED, onPropertyNavDataUpdateInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_UPDATE_STATUS_CHANGED, onPropertyNavDataUpdateStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_VERSION_INFO_CHANGED, onPropertyNavDataVersionInfoChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_SYSTEM_STATE_CHANGED, onPropertyUpdateSpmSystemStateChanged);
      PROPERTY_UPDATE_INFOSTORE_END()

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(NAVDATAUPDATE_DiagPerformFullUpdateViaUSBReqMsg)
      ON_COURIER_MESSAGE(NAVDATAUPDATE_PerformFullUpdateViaUSBReqMsg)
      ON_COURIER_MESSAGE(NAVDATAUPDATE_SpmStartMapUpdateLockResMsg)
      ON_COURIER_MESSAGE(NAVDATAUPDATE_Nav_FullMapUpdateYesReqMsg)
      ON_COURIER_MESSAGE(NAVDATAUPDATE_Nav_FullMapUpdateNoReqMsg)
      ON_COURIER_MESSAGE(NAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOkReqMsg)
      ON_COURIER_MESSAGE(UpdateNAVDATAUPDATE_PopupTextMsg)
      COURIER_MSG_MAP_END()

      static bool isMapUpdateInProgress();

      void onPropertyUpdateDeviceStatusChanged();
      void onPropertyUpdatePreparationStatusChanged();
      void onPropertyNavDataUpdateInfoChanged();
      void onPropertyNavDataUpdateStatusChanged();
      bool onPropertyUpdateSpmSystemStateChanged();
      void onPropertyNavDataVersionInfoChanged();

      bool onCourierMessage(const NAVDATAUPDATE_DiagPerformFullUpdateViaUSBReqMsg& oMsg);
      bool onCourierMessage(const NAVDATAUPDATE_PerformFullUpdateViaUSBReqMsg& oMsg);

      //Newly Added For RIVI
      bool onCourierMessage(const NAVDATAUPDATE_SpmStartMapUpdateLockResMsg& oMsg);
      bool onCourierMessage(const NAVDATAUPDATE_Nav_FullMapUpdateYesReqMsg& oMsg);
      bool onCourierMessage(const NAVDATAUPDATE_Nav_FullMapUpdateNoReqMsg& oMsg);
      bool onCourierMessage(const NAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOkReqMsg& oMsg);
      bool onCourierMessage(const UpdateNAVDATAUPDATE_PopupTextMsg& oMsg);

   private:
      enum PartitionLockError
      {
         PARTITION_LOCK_ERR___SW_UPDATING,
         PARTITION_LOCK_ERR___LOCK_FAILED,
         PARTITION_LOCK_ERR___GET_CACHE_DIR_FAILED,
         PARTITION_LOCK_ERR___UNKNOWN
      };
      enum MapUpdateMsgs
      {
         MAP_UPDATE_SUCCESSFULL,
         MAP_UPDATE_ONGOING,
         MAP_UPDATE_FILE_OLDER,
         MAP_UPDATE_INTERACTIVE,
         MAP_UPDATE_LAUNCHED,
         MAP_UPDATE_INCONSISTENT,
         MAP_UPDATE_USB_UNPLUGGED,
         MAP_UPDATE_NOT_COMPATIBLE,
         MAP_UPDATE_FILE_NOT_VALID,
         MAP_UPDATE_FILE_INSTALLATION_FAILURE,
      };
      enum MapUpdatePopupType
      {
         MAP_UPDATE_POPUP_NONE,
         MAP_UPDATE_AVAILABLE_POPUP,
         MAP_UPDATE_PROGRESS_POPUP,
         MAP_UPDATE_ERROR_POPUP
      };

      enNavDataUpdate__UpdateStatus _currentUpdateStatus;
      //enNavDataUpdate__ExportStatus _exportStatus;
      enNavDataUpdate__DeviceType _deviceType;
      bool _diagnosticModeON;
      bool _PARTITION_LOCK_ENABLED;
      bool _partitionLockRequested;
      PartitionLockError _partitionLockError;
      static bool NeedTOEnteredInMapUpdate;
      bool mapUpadateLaunchFromNaviHMI;
      MapUpdatePopupType _activePopup;

      void sendPopupDynamicTextNavDataUpdate();
      void setRemainingTimeValue(unsigned int remainingTimeInSec);
      void setDiagnosticMode(bool isDiagON);
      void sendUpdateResultToService(enNavDataUpdate_DiagFullUpdateResult result);
      bool requestAvailableUpdates(enNavDataUpdate__DeviceType deviceType);
      void performRequestAvailableUpdatesAfterLock(enNavDataUpdate__DeviceType deviceType);
      bool performRequestAvailableUpdates(enNavDataUpdate__DeviceType deviceType, const std::string& path = std::string(""));
      void triggerFullMapUpdate();
      void releaseSpmMapUpdateLock();
      void setPopupVisibility(MapUpdatePopupType popupType, bool isVisible);
      void updatePopupText(Candera::UInt8 MsgID);
      void setPopupDynamicProgressValue(float dataUpdateProgress);

      DataBindingItem<NavDataPopupTextDataBindingSource> _navDataUpdatePopupText;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(HMIModelNavDataUpdate);
};


#endif // HALL_TO_MDW_COM
#endif // HMI_MODEL_NAV_DATA_UPDATE_H
