/**************************************************************************************
* @file         : MapUtils.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include "MapUtils.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/MapUtils.cpp.trc.h"
#endif

#ifdef HALL_TO_MDW_COM

static const int DEFAULT_ZOOM_SCALE_FOR_LOCATION_OVERVIEW = 200;

using namespace navmiddleware;


bool isMultiViewActive(navmiddleware::NavMiddleware& navMiddleware)
{
   navmiddleware::settings::MapView mapView = navMiddleware.getChangeMapViewSettings().getMapView();
   bool multiViewActive = ((mapView == navmiddleware::settings::MAPVIEW_2D_SPLIT) || (mapView == navmiddleware::settings::MAPVIEW_3D_SPLIT));

   return multiViewActive;
}


bool isJunctionViewActive(navmiddleware::NavMiddleware& navMiddleware)
{
   bool junctionViewActive = (navMiddleware.getManeuverViewInfo().getManeuverViewType() == navmiddleware::MANEUVERVIEWTYPE_JUNCTION_VIEW);

   return junctionViewActive;
}


bool isIntersectionMapActive(navmiddleware::NavMiddleware& navMiddleware)
{
   bool intersectionMapActive = (navMiddleware.getManeuverViewInfo().getManeuverViewType() == navmiddleware::MANEUVERVIEWTYPE_INTERSECTION_MAP);

   return intersectionMapActive;
}


bool isAdditionalInfosActive(navmiddleware::NavMiddleware& /*navMiddleware*/)
{
   bool additionalInfoActive = false; // @Todo: Add implementation here!

   return additionalInfoActive = false;
}


bool isAutoShowTurnListOnFreewayActive(navmiddleware::NavMiddleware& navMiddleware)
{
   bool autoTurnListActive = navMiddleware.getMapSettings().isAutoShowTurnListOnFreewayEnabled();

   return autoTurnListActive;
}


bool isJunctionFreeActive(navmiddleware::NavMiddleware& navMiddleware)
{
   bool junctionFreeActive = navMiddleware.getPositionStatusInfo().getRoadProperties().isJunctionFree();

   return junctionFreeActive;
}


uint16_t getDataPixelsForDiscreteMoves(int maxScreenWidth, const navmiddleware::MapCameraModeInfo& mapCameraModeInfo)
{
   uint16_t pixelToMove = 0;
   const MapCameraMode mapCameraMode = mapCameraModeInfo.getMapCameraModeInfo();

   if (mapCameraMode == navmiddleware::MAP_MODE_FREE || mapCameraMode == navmiddleware::MAP_MODE_WEATHER_OVERVIEW)
   {
      // In map scroll mode move map 50% in flick direction
      pixelToMove = static_cast<uint16_t>(maxScreenWidth / 2);
   }
   else if (mapCameraMode == navmiddleware::MAP_MODE_CARSOR)
   {
      // In carsor locked mode move map 25% in flick direction
      pixelToMove = static_cast<uint16_t>(maxScreenWidth / 4);
   }
   ETG_TRACE_USR4(("getDataPixelsForDiscreteMoves(pixelToMove %d)", pixelToMove));
   return pixelToMove;
}


void clearLocationsShownInMap(InfoStore& infoStore, navmiddleware::NavMiddleware& navMiddleware)
{
   navmiddleware::VisibleListInfo visibleListInfo;
   visibleListInfo.setStartOffset(0);
   visibleListInfo.setRange(0);
   //visibleListInfo.setSelectedIndex(-1);

   navmiddleware::MapIconInfo mapIconInfo;
   InfoStoreBase::CoordinatesToBeShownInMap coordinates = infoStore.getCoordinatesToBeShownInMap();
   std::vector<PosWGS84<double> > coordinateVector;
   coordinateVector.clear();

   // reset POIs shown on map
   coordinates._visibleListInfo = visibleListInfo;
   coordinates._locationInputType = navmiddleware::LOCATIONINPUTTYPE_POI;
   navmiddleware::ValidValue<int> scale(DEFAULT_ZOOM_SCALE_FOR_LOCATION_OVERVIEW);
   navMiddleware.showLocationsInMap(MAP_VIEW_ID__PRIMARY, coordinates._visibleListInfo, coordinates._locationInputType, scale, navmiddleware::CameraAnimation__ADAPTIVE);

   // reset coordinates shown on map
   coordinates._mapIconInfo = mapIconInfo;
   coordinates._coordinates = coordinateVector;
   scale.setValue(coordinates._scale);
   ::std::vector< navmiddleware::GeoCoordinateDegree > optionalCoordinates;
   navMiddleware.showLocationsInMap(MAP_VIEW_ID__PRIMARY, convert(coordinates._coordinates), optionalCoordinates, coordinates._mapIconInfo, scale, navmiddleware::CameraAnimation__ADAPTIVE);
}


int findDefaultMapScaleFromNominalScales(const std::vector< navmiddleware::NominalScaleInfos::NominalScaleInfo > nomScaleInfoVector, const int defaultScale)
{
   std::vector<navmiddleware::NominalScaleInfos::NominalScaleInfo>::const_iterator itemNumber = nomScaleInfoVector.begin();
   std::vector<navmiddleware::NominalScaleInfos::NominalScaleInfo>::const_iterator itemNumberOfSmallestDelta = nomScaleInfoVector.begin();

   int minDelta = INT32_MAX;

   //in NominalScaleInfoVector find closest value to default scale
   for (; itemNumber != nomScaleInfoVector.end(); itemNumber++)
   {
      int currentDelta = abs(itemNumber->getMapScale() - defaultScale);

      if (currentDelta < minDelta)
      {
         minDelta = currentDelta;
         itemNumberOfSmallestDelta = itemNumber;
      }
      else if (currentDelta >= minDelta)
      {
         break;
      }
   }
   ETG_TRACE_USR1(("findDefaultMapScaleFromNominalScalesVector, scale: %d m", itemNumberOfSmallestDelta->getMapScale()));

   return itemNumberOfSmallestDelta->getMapScale();
}


#endif // HALL_TO_MDW_COM
