/**************************************************************************************
* @file         : MapScreenDataUtils.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#if !defined(_MAP_SCREEN_DATA_UTILS_H)
#define _MAP_SCREEN_DATA_UTILS_H

#include "../Common/Util/HMIModelIncludes.h"

#if defined(HALL_TO_MDW_COM)

static const unsigned int NUM_DIRECTION_IMAGES = 16;
static const unsigned int NUM_COMPASS_DIRECTION_IMAGES = 16;
const float COMPASS_STEP_SIZE = 22.5f;
const int MAX_NUM_COMPASS_STEPS = 16;
using namespace navmiddleware;
static const char* const _pickingDirectionImages[NUM_DIRECTION_IMAGES] =
{
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_000Bmp",
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_022Bmp",
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_045Bmp",
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_067Bmp",
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_090Bmp",
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_112Bmp",
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_135Bmp",
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_157Bmp",
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_180Bmp",
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_202Bmp",
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_225Bmp",
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_247Bmp",
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_270Bmp",
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_292Bmp",
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_315Bmp",
   "AppHmi_NavigationModule#Images#N_Map_NoRG_Move#Icon_MapFooter#IconMapFooter_arrow_inverse_337Bmp",
};


static const char* const _pickingCompassDirectionImages[NUM_COMPASS_DIRECTION_IMAGES] =
{
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_000",
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_022",
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_045",
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_067",
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_090",
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_112",
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_135",
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_157",
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_180",
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_202",
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_225",
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_247",
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_270",
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_292",
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_315",
   "AppHmi_NavigationModule#Images#N_Map_Main#Icon_North_337"
};


enum NavigationGadgetStatus
{
   NAVI_GADGET_STATUS__INITIALIZING,
   NAVI_GADGET_STATUS__NO_DATA,
   NAVI_GADGET_STATUS__NO_GUIDANCE,
   NAVI_GADGET_STATUS__ACTIVE_GUIDANCE
};


DataBindingItem<CompassButtonDataBindingSource>& getCompassButtonInfoData();
DataBindingItem<EnableOkButtonDataBindingSource>& getOkButtonInfoData();
DataBindingItem<MapScreenDataDataBindingSource>& getMapScreenData();
DataBindingItem<MapoutScreenDataDataBindingSource>& getMapoutScreenData();
DataBindingItem<NavigationGadgetInfoDataBindingSource>& getNavigationGadgetInfoData();
DataBindingItem<NaviMiddlewareStatusDataBindingSource>& getNaviMiddlewareStatusData();

static unsigned int currentCompassHeadingStep[2] = {0xFF, 0xFF};
bool sendMapScreenData();
void sendODRData();
void setMapScreenDataMapCameraInfos(const navmiddleware::MapCameraInfos& mapCameraInfos, const navmiddleware::NominalScaleInfos& nominalScaleInfos);
void setSecondaryMapScreenDataMapCameraInfos(const navmiddleware::MapCameraInfos& mapCameraInfos, const navmiddleware::NominalScaleInfos& nominalScaleInfos);
void setMapScreenDataArrivalInfos(const ArrivalInfos& arrivalInfos, bool isArrivalTimeModeActive, InfoStoreBase::EstimatedTimeType estimatedTimeType);
void clearMapScreenDataArrivalInfos();
/*This is to update time to destination and distance to destination*/
void setMapScreenDataNextManeuverInfos(const navmiddleware::NextManeuverInfos& nextManeuverInfos);
void clearMapScreenDataManeuverInfos();
void setMapScreenDataSpeedLimitInfos(const navmiddleware::SpeedInfo& speedInfo, bool speedLimitActiveStatus);
void setMapScreenDataOverSpeedInfos(bool overSpeedWarning);
void setNavigationGadgetStatus(NavigationGadgetStatus status, bool isNaviAccessible);

#endif // HALL_TO_MDW_COM
#endif // _MAP_SCREEN_DATA_UTILS_H
