/**************************************************************************************
* @file         : MapCameraAndViewHandler.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef MAP_CAMERA_AND_VIEW_HANDLER_H
#define MAP_CAMERA_AND_VIEW_HANDLER_H

#include "Common/Util/HMIModelIncludes.h"
#include "Common/Util/SurfaceSynchronizationHandler.h"
#if defined(HALL_TO_MDW_COM)

/**
* Handler for map camera and view settings
*/
//Athira: commented out SurfaceSynchronizationHandler during CGI Migration as suggested [Sept 2018]
class MapCameraAndViewHandler : public HMIModelBase, public SurfaceSynchronizationHandler
{
   public:
      MapCameraAndViewHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~MapCameraAndViewHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_SET_MAP_CAMERA_AND_VIEW_MODES_DONE, onPropertyUpdateMapCameraAndViewModesDoneChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      bool onPropertyUpdateMapCameraAndViewModesDoneChanged();
      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_MAP_MAIN_SCREEN_STATE_CHANGED, onPropertyUpdateMapSettingsChanged)
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_TM_ID_CHANGED, onPropertyUpdateTMIDChanged)
      PROPERTY_UPDATE_INFOSTORE_END()
      bool onPropertyUpdateMapSettingsChanged();
      bool onPropertyUpdateTMIDChanged();

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_CASE_DUMMY_ENTRY()
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_CLASS(SurfaceSynchronizationHandler)
      COURIER_MSG_MAP_DELEGATE_END()

      void handleMapCameraAndViewMode(enMapCameraAndViewModeMode mapCameraAndViewMode);

   private:
      void handleMapCameraAndViewModeInternal();
      std::vector<navmiddleware::ViewModeConfiguration> getViewModeConfigurationForCameraMode(enMapCameraAndViewModeMode mapCameraMode, bool junctionViewActive, bool multiViewActive, bool isGoStraightIndicationActive);
      navmiddleware::ViewModeConfiguration initializeViewConfiguration(short viewX, short viewY, short viewWidth, short viewHeight, short viewAreaX, short viewAreaY, short viewAreaWidth, short viewAreaHeight);
      void configureCrossHair(bool showCrossHair);
      bool onPrepareSurfaces();
      int32_t getDefaultScaleValue(const int32_t scale) const;

      DataBindingItem<MapMainScreenStateDataBindingSource> _mapMainScreenStateData;
      enMapCameraAndViewModeMode _requestedMapCameraAndViewMode;
      enMapCameraAndViewModeMode _lastRequestedMapCameraAndViewMode;
      navmiddleware::ManeuverViewType _lastManeuverViewType;

      std::vector<navmiddleware::ViewModeConfiguration> _requestedViewConfigurationVector;
      std::vector<navmiddleware::ViewModeConfiguration> _lastRequestedViewConfigurationVector;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(MapCameraAndViewHandler);
};


#endif // HALL_TO_MDW_COM
#endif // MAP_CAMERA_AND_VIEW_HANDLER_H
