/**************************************************************************************
* @file         : SignpostDisplayHandler.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#if !defined(_SIGNPOST_INFO_DISPLAY_HANDLER)
#define _SIGNPOST_INFO_DISPLAY_HANDLER

#include "Common/Util/HMIModelIncludes.h"
#if defined(HALL_TO_MDW_COM)


class SignpostDisplayHandler : public HMIModelBase
{
   public:
      SignpostDisplayHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~SignpostDisplayHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_SIGNPOST_CHANGED, onPropertyUpdateGuidanceSignpostInfoUpdate)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      void onPropertyUpdateGuidanceSignpostInfoUpdate();
      bool onPropertyUpdateMapCameraViewModeChanged();
      bool onPropertyUpdateHardRestrictionStatusChanged();

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_MAP_CAMERA_VIEW_MODE_CHANGED, onPropertyUpdateMapCameraViewModeChanged)
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_HARD_RESTRICTION_STATUS_CHANGED, onPropertyUpdateHardRestrictionStatusChanged)
      PROPERTY_UPDATE_INFOSTORE_END()

   protected:
      // Binding source for the Signpost area road icons and text info */
      DataBindingItem<SignpostTextDataBindingSource> _signpostTextData;

      DataBindingItem<RoadIconsDataBindingSource> _roadIconData;

      /** Set the background color in _signpostTextData */
      void setSignpostTextLines();

      /** Set the background color in _signpostTextData */
      void setSignpostBackgroundColor();

      /** Set the text color in _signpostTextData */
      void setSignpostTextColor();

      /** Set the Exit Number in _signpostTextData */
      void setExitNumber();

      void setSignpostActive(bool isSignpostAvailable);

      void sendSignpostTextData();
      void setRoadNumberIconDirection();
      void setSignpostPosition();

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(SignpostDisplayHandler);
};


#endif // HALL_TO_MDW_COM
#endif // _SIGNPOST_INFO_DISPLAY_HANDLER
