/**************************************************************************************
* @file         : LaneGuidanceHandler.h
* @author       : ECG5-Atchuta Sashank Kappagantu
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef LANEGUIDANCE_HANDLER
#define LANEGUIDANCE_HANDLER

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"

#ifdef HALL_TO_MDW_COM

class LaneGuidanceHandler : public HMIModelBase
{
   public:
      LaneGuidanceHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~LaneGuidanceHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_MANEUVERINFOS_CHANGED, onPropertyUpdateLaneDirectionInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_STATE_CHANGED, onPropertyUpdateLaneDirectionInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ETC_LANEGUIDANCE_STATUS_CHANGED, onPropertyUpdateLaneDirectionInfoChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Property updates for directions
      bool onPropertyUpdateLaneDirectionInfoChanged();
      bool onPropertyUpdateSplitMapStatusChanged();
      bool onPropertyUpdateHardRestrictionStatusChanged();

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_SPLIT_MAP_STATUS_CHANGED, onPropertyUpdateSplitMapStatusChanged)
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_HARD_RESTRICTION_STATUS_CHANGED, onPropertyUpdateHardRestrictionStatusChanged);
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE_NOTRACE(ListDateProviderReqMsg)
      COURIER_MSG_MAP_END()

      // Incoming events
      bool onCourierMessage(const ListDateProviderReqMsg& oMsg);

   private:
      bool _laneListIsEmpty;
      bool _isFromSplitRoute;

      tSharedPtrDataProvider getLaneGuidanceListDataProvider();
      int getLaneArrowAlignmentIndex(std::vector <int>& directionIndex, int directions);
      LaneGuidanceData getLaneGUIElement(const navmiddleware::LaneInfos::LaneInfo& laneInfo);
      LaneGuidanceData getLaneGuidanceData(const navmiddleware::LaneInfos::LaneInfo& laneInfo, std::vector <int>& directionIndex, const ::std::string* pBitmapNameArray);
      void updateItemBitmapImg(LaneGuidanceData& item, std::vector< Candera::MemoryManagement::SharedPointer<Candera::Image2D> >& imageVector);
      void setLaneGuidancePositionOnMap(int numLaneEntries);

      enum enLaneAlignment
      {
         LANE_ALIGN_STRAIGHT = 1,
         LANE_ALIGN_LEFT = 2,
         LANE_ALIGN_RIGHT = 4,
         LANE_ALIGN_COMBINED = 8
      };

      DataBindingItem<SplitMapScreenDataDataBindingSource>_splitMapScreenData;
};


#endif // HALL_TO_MDW_COM
#endif // _LANEGUIDANCE_HANDLER
