/**************************************************************************************
* @file         : SpellerHandler.h
* @author       : ECG5-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef SPELLER_HANDLER_H
#define SPELLER_HANDLER_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"

#ifdef HALL_TO_MDW_COM

class SpellerHandler//:public HMIModelBase
{
   public:

      //SpellerHandler(navmiddleware::NavMiddleware& _navMiddleware, InfoStore& infoStore);
      virtual ~SpellerHandler();

      // Incoming property updates from middleware
      //PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      //ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_FREE_TEXT_SEARCH_RESULTS_CHANGED, onPropertyUpdateFreeTextSearchResultsChanged)
      //PROPERTY_UPDATE_MIDDLEWARE_END()

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(Courier::UpdateModelMsg)
      ON_COURIER_MESSAGE(SpellerCtrlKeyPressed)
      ON_COURIER_MESSAGE(ResetSpellerEntryMsg)
      COURIER_MSG_MAP_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming events
      COURIER_BINDING_MAP_BEGIN()
      COURIER_BINDING_ITEM_CHANGE(SpellerPressedKeyInfoItem)
      COURIER_BINDING_ITEM_CHANGE(SpellerTextInfoItem)
      COURIER_BINDING_MAP_END()

      //virtual bool onCourierMessage(const Courier::UpdateModelMsg& oMsg);
      virtual bool onCourierMessage(const SpellerCtrlKeyPressed& oMsg);

      bool onCourierMessage(const ResetSpellerEntryMsg& oMsg);

      /** Called for the free speller when the pressed key item changed */
      bool onCourierBindingItemChange_SpellerPressedKeyInfoItem(const Courier::Request& request);

      /** Called for the free speller Called when the text item changed */
      bool onCourierBindingItemChange_SpellerTextInfoItem(const Courier::Request& request);

      /** Property Update Callback for LOCATION_ADDRESS_SPELLER_INFO_CHANGED */
      // void onPropertyUpdateFreeTextSearchResultsChanged();

      DataBindingItem<SpellerTextInfoDataBindingSource>_spellerTextInfoData;
      DataBindingItem<SpellerPagesDataBindingSource> _spellerPageInfoData;
      DataBindingItem<SpellerPressedKeyInfoDataBindingSource> _spellerPressedKeyInfoData;
      static SpellerHandler* getInstance();
      Candera::String GetEditFieldText();
      Candera::String _editFieldText;
      void ResetEditFieldTextValues(Candera::String resetString);
      bool _clearSpellerEntry;
      static SpellerHandler* s_instance;
   private:
      SpellerHandler();
      Candera::UInt8 m_u8CurrentSpellerPage;
      tSharedPtrDataProvider getFreetextListDataProvider(unsigned int listId, unsigned int startIndex, unsigned int windowElementSize) const;
      void ProcessSpellerString();
      FEATSTD_MAKE_CLASS_UNCOPYABLE(SpellerHandler);
};


#endif // HALL_TO_MDW_COM
#endif // SPELLER_HANDLER_H
