/**************************************************************************************
* @file         : SpellerHandler.cpp
* @author       : ECG5-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"

#include "util/StrUtf8.h"
#include "AppHmi_NavigationStateMachine.h"
#include "SpellerHandler.h"
#include "hmi_trace_if.h"
#include "CgiExtensions/ImageLoader.h"
#include "CgiExtensions/CourierMessageMapper.h"

#define XML_NAME_TAG_START "<?xml><NAME>"
#define XML_NAME_TAG_END "</NAME>"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#include "trcGenProj/Header/SpellerHandler.cpp.trc.h"
#endif

static const char* const EMPTY_STRING = "";
static const Candera::UInt32 CONTROL_CHAR_SHIFT_1 = 9524;
static const Candera::UInt32 CONTROL_CHAR_SHIFT_2 = 9488;
static const Candera::UInt32 CONTROL_CHAR_SPACE   = 32;

#ifdef HALL_TO_MDW_COM

SpellerHandler* SpellerHandler::s_instance = 0;

SpellerHandler::SpellerHandler() : m_u8CurrentSpellerPage(0), _clearSpellerEntry(true), _editFieldText(EMPTY_STRING)
{
}


SpellerHandler* SpellerHandler::getInstance()
{
   if (NULL == s_instance)
   {
      s_instance = new SpellerHandler();
   }

   return s_instance;
}


SpellerHandler::~SpellerHandler()
{
}


bool SpellerHandler::onCourierBindingItemChange_SpellerPressedKeyInfoItem(const Courier::Request& request)
{
   //// this is only called for free text speller!

   _spellerPressedKeyInfoData.SetValue(request.ItemKey(), request.GetItemValue());
   _spellerPressedKeyInfoData.MarkItemModified(ItemKey::SpellerPressedKeyInfoItem);
   _spellerPressedKeyInfoData.SendUpdate(true);

   return true;
}


bool SpellerHandler::onCourierBindingItemChange_SpellerTextInfoItem(const Courier::Request& request)
{
   // this is only called for free text speller!
   _spellerTextInfoData.SetValue(request.ItemKey(), request.GetItemValue());
   _spellerTextInfoData.MarkItemModified(ItemKey::SpellerTextInfoItem);
   _spellerTextInfoData.SendUpdate();

   return true;
}


bool SpellerHandler::onCourierMessage(const SpellerCtrlKeyPressed& oMsg)
{
   Candera::UInt32 l_u32RecivedControChar = oMsg.GetCtrlKeyChar();
   ETG_TRACE_USR4(("SpellerHandler::onCourierMessage(SpellerCtrlKeyPressed(%d))", l_u32RecivedControChar));
   if ((CONTROL_CHAR_SHIFT_1 == l_u32RecivedControChar) || (CONTROL_CHAR_SHIFT_2 == l_u32RecivedControChar))
   {
      const Candera::UInt8 TOTAL_SYMBOL_PAGES = 3;
      const Candera::UInt8 PAGENUMBER_SIZE    = 30;
      char currPageNumberStr[PAGENUMBER_SIZE];
      m_u8CurrentSpellerPage = (m_u8CurrentSpellerPage % TOTAL_SYMBOL_PAGES) + 1;
      snprintf(currPageNumberStr, sizeof(currPageNumberStr), "%d/%d", m_u8CurrentSpellerPage, TOTAL_SYMBOL_PAGES);
      (*_spellerPageInfoData).mSpellerPageNumber = currPageNumberStr;
   }
   else if (CONTROL_CHAR_SPACE != l_u32RecivedControChar) // 32 is the ascii value for space
   {
      (*_spellerPageInfoData).mSpellerPageNumber = "ÆØÜ";
      m_u8CurrentSpellerPage = 0;
   }
   else
   {
      // do nothing
   }
   _spellerPageInfoData.SendUpdate(true);
   return false;
}


Candera::String SpellerHandler::GetEditFieldText()
{
   return _editFieldText;
}


void SpellerHandler::ResetEditFieldTextValues(Candera::String resetString)
{
   m_u8CurrentSpellerPage = 0;
   (*_spellerPressedKeyInfoData).mPressedKey = resetString;
   (*_spellerTextInfoData).mText = resetString;
   (*_spellerPageInfoData).mSpellerPageNumber = "ÆØÜ";
   _spellerPressedKeyInfoData.MarkItemModified(ItemKey::SpellerPressedKeyInfoItem);
   _spellerTextInfoData.MarkItemModified(ItemKey::SpellerTextInfoItem);
   _spellerPressedKeyInfoData.SendUpdate(true);
   _spellerTextInfoData.SendUpdate(true);
   _spellerPageInfoData.SendUpdate(true);
}


bool SpellerHandler::onCourierMessage(const ResetSpellerEntryMsg& oMsg)
{
   //This couriermsg is triggerd on exit of speller scene
   //Value is reseted/retained based on the button pressed in spellermatchlist scene
   //Previously typed string is stored in _editFieldText

   _clearSpellerEntry = oMsg.GetIsResetSpellerEntry();
   if (true == _clearSpellerEntry)
   {
      _editFieldText = (*_spellerTextInfoData).mText;
      ResetEditFieldTextValues(Candera::String(EMPTY_STRING));
   }
   else
   {
      ResetEditFieldTextValues(_editFieldText);
   }

   return true;
}


#endif // HALL_TO_MDW_COM
