/**************************************************************************************
* @file         : DestinationAddressInputHandler.h
* @author       : ECG5-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef DESTINATION_ADDRESS_INPUT_HANDLER_H
#define DESTINATION_ADDRESS_INPUT_HANDLER_H

#include "Common/Util/HMIModelIncludes.h"   // Includes other data model related header files
#include "Settings/NaviSettingsUtil.h"      // For accessing default text entries to be shown on address input scene

#ifdef HALL_TO_MDW_COM

const unsigned int MAX_ADDRESS_CATEGORY = 6;               // Maximum number of address input categories supported
const unsigned int MAX_ADDRESS_CATEGORY_POI_SEARCH = 3;    // Maximum number of address input categories supported by POI search
const unsigned int LIST_WINDOW_SIZE = 20;
const Courier::ViewId POI_INPUT_SCENENAME         = Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_MyPOIs_AddressInput");
const Courier::ViewId DESTINATION_INPUT_SCENENAME = Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDest_AddressInput");

using namespace navmiddleware;

class DestinationAddressInputHandler : public HMIModelBase
{
   public:
      DestinationAddressInputHandler(navmiddleware::NavMiddleware& _navMiddleware, InfoStore& _infoStore);
      virtual ~DestinationAddressInputHandler();
      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_ADRESS_INPUT_INFO_CHANGED, onPropertyUpdateAddressInputInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_ADDRESS_ELEMENTS_CHANGED, onPropertyUpdateAddressElementChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      virtual void onPropertyUpdateAddressInputInfoChanged();
      virtual void onPropertyUpdateAddressElementChanged();

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(InitDestinationInputReqMsg)
      ON_COURIER_MESSAGE(UpdateSpeedLockPopupTextReqMsg)
      ON_COURIER_MESSAGE(SpellerOKBtnPressedMsg)
      ON_COURIER_MESSAGE(SetPOISearchLocationReqMsg)
      ON_COURIER_MESSAGE(LeaveFormBasedAddressInputReqMsg)
      COURIER_MSG_MAP_END()

      virtual bool onCourierMessage(const ButtonReactionMsg& oMsg);
      virtual bool onCourierMessage(const SpellerOKBtnPressedMsg& oMsg);
      virtual bool onCourierMessage(const InitDestinationInputReqMsg& oMsg);
      virtual bool onCourierMessage(const UpdateSpeedLockPopupTextReqMsg& oMsg);
      virtual bool onCourierMessage(const SetPOISearchLocationReqMsg& oMsg);
      virtual bool onCourierMessage(const LeaveFormBasedAddressInputReqMsg& oMsg);

   protected:
      bool _isCCPAddressInfo;
      Candera::UInt32 _addressInputRequestScene;                    // Scene from which hierarchical address input is initiated (New Destination or POI search)
      navmiddleware::AddressCategory _topLevelAddressCategory;      // STATE for NAR region, COUNTRY for EUR region
      navmiddleware::AddressCategory _selectedAddressInputCategory; // Address input category last selected by the user
      bool* addressBtnState[MAX_ADDRESS_CATEGORY];                  // Enable/Disable address input field

   private:
      DataBindingItem<DEDisableButtonDataBindingSource>        _addressEntryBtnState;
      DataBindingItem<AddressInputValueDataBindingSource>      _newAddressInputValue;
      DataBindingItem<AddressEntryTitleTextDataBindingSource>  _addressEntryTitleData;
      DataBindingItem<AddressInputValDetailsDataBindingSource> _addressInputValDetailsData;
      DataBindingItem<AddressInputValPOIDataBindingSource>     _addressInputValPOIData;
      DataBindingItem<MultiLinePopuptextDataBindingSource>     _PopupText;

      void setCoordinateToBeShownInMap();
      void onUpdateNewDestinationAddressInput();
      void onUpdatePOISearchAddressInput();
      bool changeDestinationInputValue(Candera::String* addressInputDataBinding,
                                       Candera::String& addressInputMiddlewareInfo,
                                       navmiddleware::AddressCategory currentAddressCategory,
                                       bool isAddressInputSelectable);
      FEATSTD_MAKE_CLASS_UNCOPYABLE(DestinationAddressInputHandler);
};


#endif // HALL_TO_MDW_COM
#endif // DESTINATION_ADDRESS_INPUT_HANDLER_H
