/**************************************************************************************
* @file         : TraceCommandHandler.h
* @author       : ECG5-Atchuta Sashank Kappagantu
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef HMI_MODEL_TRACE_COMMAND_H
#define HMI_MODEL_TRACE_COMMAND_H

#include "HMIModelIncludes.h"

#if defined(HALL_TO_MDW_COM)

class TraceCommandHandler
{
   public:
      TraceCommandHandler();
      virtual ~TraceCommandHandler();

      // Initialize navMiddleware pointer
      static void initialize(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);

      // Pointer to NavMiddleware instance
      static navmiddleware::NavMiddleware* _sNavMiddleware;

      // Pointer to Infostore instance
      static InfoStore* _sInfoStore;
      static int _demoModeSpeed;

      // TTFIS commands Route Calulation
      static void traceCmd_setCoordinates(std::string coordinates);
      static void traceCmd_startGuidance();
      static void traceCmd_stopGuidance();

      //TO DO : TTFIS commands Waypoints
      static void traceCmd_initializeWaypoints();
      static void traceCmd_clearWaypoints();
      //static void traceCmd_applyWaypointsChanges();
      //static void traceCmd_insertWaypoint(unsigned int index);
      static void traceCmd_deleteWaypoint(unsigned int index);
      //static void traceCmd_replaceWaypoint(unsigned int index);
      //static void traceCmd_moveWaypoint(unsigned int currentIndex, unsigned int newIndex);

      static void traceCmd_setDemoMode(bool demoModeState);
      static void traceCmd_cancelRouteGuidance();

      //TTFIS commands to set start Position
      static void traceCmd_setDemoStartPosition(std::string coordinates);

      static void traceCmd_getRGState();

      static void traceCmd_getDemoModeState();

      static void traceCmd_getMapOrientation();

      static void traceCmd_setMapOrientation(int mapviewType, int mapOrientation, int mapPitch);

      static void traceCmd_getCurrentSystemLanguage();

      static void traceCmd_getCurrentDistanceUnit();

      static void traceCmd_getCurrentSpeed();

      static void traceCmd_getCurrentDirection();

      static void traceCmd_getCurrentOrthoMetricHeight();

      static void traceCmd_getCurrentETA();

      static void traceCmd_getCurrentPosition();

      static void traceCmd_setZoomIn(unsigned int MapViewType, unsigned int stepcount);

      static void traceCmd_setZoomOut(unsigned int MapViewType, unsigned int stepcount);

      static void traceCmd_getDistanceToDestination();

      static void traceCmd_getCurrentMapView();

      static void traceCmd_getCurrentCameraPosition();

      //TTFIS commands to get current compass heading
      static void traceCmd_getCurrentCompassHeading();
      //TTFis commands to get and set Avoid Areas
      static void traceCmd_getCurrentAvoidAreas();
      static void traceCmd_setAvoidAreas(std::string coordinates);
      //TTFis command to get lane guidance info
      static void traceCmd_getLaneGuidanceInfo();
      //TTFis command to get address from coordinates
      static void traceCmd_getCurrentAddress();
      static void traceCmd_getAddressFromGPSCoordinates(std::string coordinates);
      //TTFis command to get Dest and Waypoints Description
      static void traceCmd_getDestDescription();

      // TTFIS commands for Demo Mode ON/OFF
      static void traceCmd_startDemoMode();
      static void traceCmd_stopDemoMode();
      static void traceCmd_increaseDemoModeSpeed();
      static void traceCmd_decreaseDemoModeSpeed();
      static void traceCmd_getDemoModeSpeed();
      static void traceCmd_setDemoModeSpeed(unsigned int speed);
      static void traceCmd_setDistanceUnit(unsigned int distanceUnit);

      static void traceCmd_setCameraFromCoordinates(std::string coordinates);
      static void traceCmd_pickInMap();

      static void traceCmd_getListImageProperties();
      static void traceCmd_setSpeedLockState(bool speedLockState);
      static void traceCmd_setMapStreamState(bool mapStreamState);
      static void traceCmd_setAutoZoomEnabled(bool autoZoomEnabled);

   private:

      enum TurnListIconType
      {
         TURN_LIST_ICON_TYPE_ROUNDABOUT_EXIT_STRAIGHT,
         TURN_LIST_ICON_TYPE_ROUNDABOUT_EXIT_HALF_RIGHT,
         TURN_LIST_ICON_TYPE_ROUNDABOUT_EXIT_RIGHT,
         TURN_LIST_ICON_TYPE_ROUNDABOUT_EXIT_SHARP_RIGHT,
         TURN_LIST_ICON_TYPE_ROUNDABOUT_EXIT_BACK,
         TURN_LIST_ICON_TYPE_ROUNDABOUT_EXIT_SHARP_LEFT,
         TURN_LIST_ICON_TYPE_ROUNDABOUT_EXIT_LEFT,
         TURN_LIST_ICON_TYPE_ROUNDABOUT_EXIT_HALF_LEFT,
         TURN_LIST_ICON_TYPE_KEEP_LEFT,
         TURN_LIST_ICON_TYPE_KEEP_RIGHT,
         TURN_LIST_ICON_TYPE_TURN_STRAIGHT,
         TURN_LIST_ICON_TYPE_TURN_HALF_RIGHT,
         TURN_LIST_ICON_TYPE_TURN_RIGHT,
         TURN_LIST_ICON_TYPE_TURN_SHARP_RIGHT,
         TURN_LIST_ICON_TYPE_UTURN_LEFT,
         TURN_LIST_ICON_TYPE_TURN_SHARP_LEFT,
         TURN_LIST_ICON_TYPE_TURN_LEFT,
         TURN_LIST_ICON_TYPE_TURN_HALF_LEFT,
         TURN_LIST_ICON_TYPE_EXIT_LEFT,
         TURN_LIST_ICON_TYPE_EXIT_RIGHT,
         TURN_LIST_ICON_TYPE_UTURN_RIGHT,
         TURN_LIST_ICON_TYPE_MOTORWAY_INTERSECTION,
         TURN_LIST_ICON_TYPE_BORDER_CROSSING,
         TURN_LIST_ICON_TYPE_WAYPOINT_FLAG,
         TURN_LIST_ICON_TYPE_DESTINATION_FLAG,
         TURN_LIST_ICON_TYPE_SERVICE_ACCESS,
         TURN_LIST_ICON_TYPE_INVALID
      };
};


#endif // HALL_TO_MDW_COM
#endif // HMI_MODEL_TRACE_COMMAND_H
