/**************************************************************************************
* @file         : StringUtils.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include <stdlib.h>
#include <errno.h>
#include "StringUtils.h"
#include <algorithm>
std::string getSubstring(const std::string& stringToExtract, unsigned int fromPos, unsigned int numChar)
{
   std::string retString;
   if ((numChar > 0) && ((fromPos + numChar) <= stringToExtract.length()))
   {
      retString = stringToExtract.substr(fromPos, numChar);
   }
   return retString;
}


std::string getSubstringRecursive(const std::string& modifiedStr, const std::string& separator, unsigned int match)
{
   if ((0 == match) || modifiedStr.empty())
   {
      return std::string("");
   }

   std::size_t foundPos = modifiedStr.find(separator);

   if (foundPos == std::string::npos)
   {
      return std::string("");
   }

   if (1 == match)
   {
      return getSubstring(modifiedStr, 0, foundPos);
   }

   unsigned int fromPos = foundPos + separator.length();
   unsigned int numChar = modifiedStr.length() - fromPos;
   return getSubstringRecursive(getSubstring(modifiedStr, fromPos, numChar), separator, (match - 1));
}


std::string getSubstring(const std::string& stringToExtract, const std::string& separator, unsigned int match)
{
   if ((0 == match) || stringToExtract.empty())
   {
      return std::string("");
   }

   if (stringToExtract.find(separator) != std::string::npos)
   {
      return getSubstringRecursive(stringToExtract + separator, separator, match);
   }
   else
   {
      return std::string("");
   }
}


double stringToDouble(const std::string& inputString)
{
   errno = 0;
   double retVal = strtod(inputString.c_str(), NULL);
   if (0 != errno)
   {
      retVal = 0.0;
   }
   return retVal;
}


int stringDecToInt(const std::string& inputString)
{
   errno = 0;
   int retVal = 0;
   long int value = strtol(inputString.c_str(), NULL, 10);
   if (0 == errno)
   {
      retVal = static_cast< int >(value);
   }
   return retVal;
}


void findSubStringHighlightIndex(const Candera::String sourceText, const Candera::String  subString, unsigned long& highlightStartIndex, unsigned long& highlightCount, bool ignoreCase)
{
   Candera::String tempSrcText = sourceText;
   Candera::String tempSubStrText = subString;
   if (ignoreCase)
   {
      //convert the reference string to upper case
      std::string upperCaseString = tempSrcText.GetCString();
      std::transform(upperCaseString.begin(), upperCaseString.end(), upperCaseString.begin(), toupper);
      tempSrcText = upperCaseString.c_str();
      upperCaseString.clear();

      //conert the substring to upper case
      upperCaseString = tempSubStrText.GetCString();
      std::transform(upperCaseString.begin(), upperCaseString.end(), upperCaseString.begin(), toupper);
      tempSubStrText = upperCaseString.c_str();
      upperCaseString.clear();
   }
   const char* copText = tempSrcText.GetCString();
   const unsigned long sourceTextLength = tempSrcText.GetCodePointCount();
   const unsigned long subStrLength = tempSubStrText.GetCodePointCount();
   const unsigned long subStrCharCount = tempSubStrText.GetCharCount();

   for (unsigned long searchIndex = 0; searchIndex < sourceTextLength; searchIndex++)
   {
      int iRes;

      iRes = memcmp(copText, tempSubStrText.GetCString(), subStrCharCount);

      if (iRes == 0)
      {
         highlightStartIndex = searchIndex;
         highlightCount = subStrLength;
         return;
      }

      FeatStd::Internal::TextEncoding::Advance(copText);
   }
   highlightStartIndex = 0;
   highlightCount = 0;
}
