/**************************************************************************************
* @file         : StaticListHandlerBase.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef _STATIC_LIST_HANDLER_BASE_H
#define _STATIC_LIST_HANDLER_BASE_H

#include "HMIModelIncludes.h"
//#include "SpeedLockUtils.h"
#include "InfoStorePropertyUpdateConsumer.h"

#if defined(HALL_TO_MDW_COM)

enum enStaticListFocusLockStatus
{
   STATIC_LIST_FOCUS_UNLOCK = 1,
   STATIC_LIST_FOCUS_LOCK
};


class ListFocuslockInfo
{
   public:
      ListFocuslockInfo(): listId(0), rowId(0), columnId(0)
      {
      }
      ~ListFocuslockInfo()
      {
      }
      unsigned int listId;
      unsigned int rowId;
      unsigned int columnId;
};


class StaticListHandlerBase : public InfoStorePropertyUpdateConsumer
{
   public:
      StaticListHandlerBase(InfoStore& infoStore);
      virtual ~StaticListHandlerBase();

      //// register for list widget messages
      //COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      //ON_COURIER_MESSAGE_NOTRACE(ButtonReactionMsg)
      //ON_COURIER_MESSAGE_NOTRACE(ListDateProviderReqMsg)
      //ON_COURIER_MESSAGE_NOTRACE(ListChangedUpdMsg)
      //ON_COURIER_MESSAGE_NOTRACE(RestorePreviousListPositionReqMsg)
      //ON_COURIER_MESSAGE(ListFocusLockReqMsg)
      //ON_COURIER_MESSAGE(ListFocusLockDataResetReqMsg)
      //COURIER_MSG_MAP_END();

      //void performListFocusLockResetOnButtonPress(const ButtonReactionMsg& oMsg);
      //void clearLastListFocusLockInfo();
      //bool getSpeedLockListElementStatus(unsigned int index);
      enStaticListFocusLockStatus _focusLockStatus; //to identify focus lock current status
      //ListFocuslockInfo _currentFocusLockListInfo; //to identify focus lock current list info
      //virtual bool onCourierMessage(const ButtonReactionMsg& oMsg);
      //virtual bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      //virtual bool onCourierMessage(const ListChangedUpdMsg& oMsg);
      //virtual bool onCourierMessage(const RestorePreviousListPositionReqMsg& oMsg);
      //bool onCourierMessage(const ListFocusLockReqMsg& oMsg);
      //bool onCourierMessage(const ListFocusLockDataResetReqMsg& oMsg);

      ///** Called when the list should initialize itself */
      //virtual void initialize() = 0;

      ///** Called when the list should deinitialize itself */
      //virtual void deinitialize() = 0;

   protected:
      virtual tSharedPtrDataProvider getListDataProvider() = 0;
      //virtual ::Courier::UInt32 getListId() = 0;
      //virtual bool handleButtonReactionMsg(const ButtonReactionMsg& oMsg) = 0;
      //virtual bool handleListChangedUpdMsg(const ListChangedUpdMsg& /*oMsg*/)
      //{
      //   return false;
      //}
      //virtual SpeedLockConfig getSpeedLockStatus(unsigned int /*index*/)
      //{
      //   return SPEEDLOCK_CONFIG_NONE;
      //}
      void updateStaticList();
      //void setLastListPositionEnable(bool enable)
      //{
      //   _setLastPositionEnabled = enable;
      //}

      int _previousFirstVisibleIndex;
      bool _setLastPositionEnabled;
      static bool _restorePreviousListPositionRequested;

      //FEATSTD_MAKE_CLASS_UNCOPYABLE(StaticListHandlerBase);
};


#endif // HALL_TO_MDW_COM
#endif // _STATIC_LIST_HANDLER_BASE_H
