/**************************************************************************************
* @file         : NavMiddlewareUtils.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef NAVMIDDLEWAREUTILS_H
#define NAVMIDDLEWAREUTILS_H 1

#include "HMIModelDefines.h"
#include "PosWGS84.h"
#include "ImageUtils.h"
#include "Candera/System/MemoryManagement/SharedPointer.h"
#include "Candera/Engine2D/Core/BitmapImage2D.h"

#if defined(HALL_TO_MDW_COM)

static const unsigned int MANEUVER_DIRECTION_SYMBOL_OFFSET = navmiddleware::MANEUVER_SYMBOL_SIZE;
static const unsigned int emptyManeuverSymbol = navmiddleware::DIRECTIONDESCRIPTION_SIZE + MANEUVER_DIRECTION_SYMBOL_OFFSET;

void startGuidanceToPosWGS84(navmiddleware::NavMiddleware& navMiddleware, PosWGS84<double> posWGS84);
void startGuidanceToPickingResult(navmiddleware::NavMiddleware& navMiddleware, const navmiddleware::PickingResults::PickingResult& pickingResult);
std::string getCustomizedPOICategory(navmiddleware::NavMiddleware& navMiddleware, unsigned int index);
std::string convertCoordinateFormatToDegMinSec(std::string inputString);
Candera::MemoryManagement::SharedPointer<Candera::BitmapImage2D> getCustomizedPOIIcon(navmiddleware::NavMiddleware& navMiddleware, unsigned int index);
unsigned int mapManeuverOrDirectionSymbolIndex(const navmiddleware::ManeuverSymbolType& maneuverSymbolType, const navmiddleware::ManeuverSymbol maneuver,
      const navmiddleware::DirectionDescription& destDirection, const navmiddleware::DirectionDescription& entryPointDirection,
      bool isValid);


/** property update defines */
#define PROPERTY_UPDATE_MIDDLEWARE_BEGIN() \
   virtual void onPropertyUpdate(const navmiddleware::PropertyUpdateCallback::T_PropertyIdentifierContainer& propertyIdentifiers) \
   { \
      for (T_PropertyIdentifierContainer::const_iterator pos = propertyIdentifiers.begin(); pos != propertyIdentifiers.end(); ++pos) \
                  { \

#define ON_PROPERTY_MIDDLEWARE_UPDATE(_property_, _method_) \
   if (*pos == _property_) \
   { \
      _method_(); \
   } \

#define ON_PROPERTY_MIDDLEWARE_UNUSED() \
   COURIER_UNUSED(propertyIdentifiers); \

#define PROPERTY_UPDATE_MIDDLEWARE_END() \
                  } \
   } \

#endif // HALL_TO_MDW_COM
#endif // NAVMIDDLEWAREUTILS_H
